<div class="entry-content single-page">
    <h2 id="project-description"><?php _e('Description', 'erua'); ?></h2>

    <?php the_content(); ?>

    <?php
    global $website_url, $status, $project_significance, $project_results, $funding_source, $funding_programme, $universities, $project_regions, $project_stakeholders, $role, $consortium, $countries, $topic, $keywords, $science_fields;

    if ( $website_url ) {
        echo '<h2 id="project-url">' .__('Webpage', 'erua') . '</h2>';
        echo '<p><a id="project-website" href="' . $website_url . '" target="_blank" rel="nofollow">' . $website_url . '</a></p>';
    }

    if ( $status ) {
        echo '<h2 id="project-status">' .__('Status', 'erua') . '</h2>';
        echo '<span class="project-status ' . $status[0]->slug . '">' . $status[0]->name . '</span>';

        if ( $start_date = get_field('aeiforia_project_date_start', get_the_ID()) ) {
            echo '<p>';
            echo date("M-d, Y", strtotime($start_date));
            if ( $end_date = get_field('aeiforia_project_date_end', get_the_ID()) ) {
                echo ' to ' . $end_date;
            }
            echo '</p>';
        }

        if ( $project_significance ) {
            echo '<h2 id="project-significance">' .__('Socio-economic significance', 'erua') . '</h2>';
            echo '<p>' . $project_significance . '</p>';
        }

        if ( $project_results ) {
            echo '<h2 id="project-results">' .__('Results', 'erua') . '</h2>';
            echo '<p>' . $project_results . '</p>';
        }
    }

    if ( $funding_source ) {
        echo '<h2 id="project-funding">' .__('Funding Source', 'erua') . '</h2>';
        echo '<p>' . $funding_source[0]->name . '</p>';        
    }

    if ( $funding_programme ) {
        echo '<h2 id="project-funding-programme">' .__('Funding Programme', 'erua') . '</h2>';
        echo '<p>' . $funding_programme . '</p>';        
    }

    if ( $universities ) {
        global $aeiforia_erua_university_taxonomy;
        echo '<universities id="project-universities" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('ERUA University/ies', 'erua') . '</h2>';
        if ( is_array($universities) ) {
            foreach ( $universities as $key => $university ) {
                $separator = ( $key === array_key_last($universities) ) ? '' : ', ';
        
                echo '<span class="project-university"><a href="' . site_url('/') . $aeiforia_erua_university_taxonomy->rewrite['slug'] . '/' . $university->slug . '">'. $university->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</universities>';
    }

    if ( $project_regions ) {
        global $aeiforia_erua_region_taxonomy;
        echo '<regions id="project-regions" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('ERUA Regions', 'erua') . '</h2>';
        if ( is_array($project_regions) ) {
            foreach ( $project_regions as $key => $region ) {
                $separator = ( $key === array_key_last($project_regions) ) ? '' : ', ';
        
                echo '<span class="project-region"><a href="' . site_url('/') . $aeiforia_erua_region_taxonomy->rewrite['slug'] . '/' . $region->slug . '">'. $region->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</regions>';
    }

    if ( $project_stakeholders ) {
        global $aeiforia_erua_stakeholder_taxonomy;
        echo '<stakeholders id="project-stakeholders" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('ERUA Stakeholders', 'erua') . '</h2>';
        if ( is_array($project_stakeholders) ) {
            foreach ( $project_stakeholders as $key => $stakeholder ) {
                $separator = ( $key === array_key_last($project_stakeholders) ) ? '' : ', ';
        
                echo '<span class="project-stakeholder"><a href="' . site_url('/') . $aeiforia_erua_stakeholder_taxonomy->rewrite['slug'] . '/' . $stakeholder->slug . '">'. $stakeholder->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</stakeholders>';
    }

    if ( $role ) {
        echo '<h2 id="project-role">' .__('Role', 'erua') . '</h2>';
        echo '<p>' . $role . '</p>';
    }

    if ( $topic ) {
        echo '<h2 id="project-topic">' .__('Topic', 'erua') . '</h2>';
        echo '<p>' . $topic . '</p>';
    }

    if ( $countries ) {
        echo '<h2 id="project-countries">' .__('Countries', 'erua') . '</h2>';
        echo '<countries style="display: block; margin-bottom: 20px;">';
        if ( is_array($countries) ) {
            foreach ( $countries as $key => $country ) {
                $separator = ( $key === array_key_last($countries) ) ? '' : ', ';
        
                echo '<span class="project-country">'. $country['label'] .'</a>' . $separator . '</span>';
            }
        }
        echo '</countries>';
    }

    if ( $consortium ) {
        echo '<h2 id="project-consortium">' .__('Consortium', 'erua') . '</h2>';
        echo '<p>' . $consortium . '</p>';
    }

    if ( $keywords ) {
        global $aeiforia_project_keyword_tags;
        echo '<keywords id="project-keywords" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Keywords', 'erua') . '</h2>';
        if ( is_array($keywords) ) {
            foreach ( $keywords as $key => $keyword ) {
                $separator = ( $key === array_key_last($keywords) ) ? '' : ', ';
        
                echo '<span class="project-keyword project-tag"><a href="' . site_url('/') . $aeiforia_project_keyword_tags->rewrite['slug'] . '/' . $keyword->slug . '">'. $keyword->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</keywords>';
    }

    if ( $science_fields ) {
        global $aeiforia_science_field_tags;
        echo '<science-fields id="project-science-fields" style="display: block; margin-bottom: 20px;">';
        echo '<h2>' .__('Fields of science', 'erua') . '</h2>';
        if ( is_array($science_fields) ) {
            foreach ( $science_fields as $key => $sf ) {
                $separator = ( $key === array_key_last($science_fields) ) ? '' : ', ';
        
                echo '<span class="project-science-field project-tag"><a href="' . site_url('/') . $aeiforia_science_field_tags->rewrite['slug'] . '/' . $sf->slug . '">'. $sf->name .'</a>' . $separator . '</span>';
            }
        }
        echo '</science-fields>';
    }
    ?>

    <?php
    wp_link_pages();
    ?>

    <?php if ( get_theme_mod( 'blog_share', 1 ) ) {
        // SHARE ICONS
        echo '<div class="blog-share text-center">';
        echo '<div class="is-divider medium"></div>';
        echo do_shortcode( '[share]' );
        echo '</div>';
    } ?>
</div>

<?php if ( get_theme_mod( 'blog_single_footer_meta', 1 ) ) : ?>
    <footer class="entry-meta text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
        <?php
        /* translators: used between list items, there is a space after the comma */
        $category_list = get_the_category_list( __( ', ', 'flatsome' ) );

        /* translators: used between list items, there is a space after the comma */
        $tag_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );


        // But this blog has loads of categories so we should probably display them here.
        if ( '' != $tag_list ) {
            $meta_text = __( 'This entry was posted in %1$s and tagged %2$s.', 'flatsome' );
        } else {
            $meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'flatsome' );
        }

        printf( $meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute( 'echo=0' ) );
        ?>
    </footer>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_author_box', 1 ) ) : ?>
    <div class="entry-author author-box">
        <div class="flex-row align-top">
            <div class="flex-col mr circle">
                <div class="blog-author-image">
                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'flatsome_author_bio_avatar_size', 90 ) ); ?>
                </div>
            </div>
            <div class="flex-col flex-grow">
                <h5 class="author-name uppercase pt-half">
                    <?php the_author_meta( 'display_name' ); ?>
                </h5>
                <p class="author-desc small"><?php the_author_meta( 'description' ); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ( get_theme_mod( 'blog_single_next_prev_nav', 1 ) ) :
    flatsome_content_nav( 'nav-below' );
endif; ?>
