<?php
/**
 * Block Name: Hackathon Rules
 *
 * This is the template that displays the Hackathon Rules block.
 */

// create id attribute for specific styling
$id = 'hackathon-rules-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-rules'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

$hackathon_rules = get_field('hackathon_rules');
$hackathon_faq = get_field('hackathon_faq');
?>
<div id="<?php echo $id; ?>" class="hackathon-rules <?php echo $align_class; ?>">
    <?php if ( $hackathon_rules || $hackathon_faq ) : ?>
    <div id="hackathon-rules-faq" class="tabbed-content">
        <ul class="nav nav-tabs nav-vertical nav-uppercase nav-size-normal nav-left" role="tablist">
            <?php if ( $hackathon_rules ) : ?>
            <li id="tab-tab-1-title" class="tab active has-icon" role="presentation"><a href="#hackathon-rules" role="tab" aria-selected="true" aria-controls="hackathon-rules"><span><?php _e('Rules', 'erua'); ?></span></a></li>
            <?php endif; ?>
            <?php if ( $hackathon_faq ) : ?>
            <li id="tab-tab-2-title" class="tab has-icon" role="presentation"><a href="#hackathon-faq" tabindex="-1" role="tab" aria-selected="false" aria-controls="hackathon-faq"><span><?php _e('FAQ', 'erua'); ?></span></a></li>
            <?php endif; ?>
        </ul>
        <div class="tab-panels">
            <?php if ( $hackathon_rules ) : ?>
            <div id="hackathon-rules" class="panel active entry-content" role="tabpanel" aria-labelledby="tab-tab-1-title"><?php echo $hackathon_rules; ?></div>
            <?php endif; ?>
            <?php if ( $hackathon_faq ) : ?>
            <div id="hackathon-faq" class="panel entry-content" role="tabpanel" aria-labelledby="tab-tab-2-title"><?php echo $hackathon_faq; ?></div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
</div>