<?php
/**
 * Template Name: Spotlights Blog
 * Template Post Type: page
 *
 * This page template is solely used by the Spotlights Blog.
 */

//================================================================================
// Setup CSS and JS.
//================================================================================

function setup_spotlights_styles() {
    wp_enqueue_style( 'spotlights-style' );
}
add_action('wp_head', 'setup_spotlights_styles');

//================================================================================
// Build the Query.
//================================================================================

$query_args = [
    'post_type' => ['post', 'aeiforia-project', 'eruahaus-project', 'showroom', 'creative-blog-post', 'hackathon', 'funding-opportunity', 'job-opportunity', 'event'],
    //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
    'post_status' => 'publish',
    'orderby'     => 'date',
    'numberposts' => -1,
    //'numberposts' => '5',
    'posts_per_page' => 10, # get_option('posts_per_page'),
    'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
];

//================================================================================
// CONTINUE THE PAGE
//================================================================================

get_header();
do_action( 'flatsome_before_page' ); ?>

<div id="content" class="eruahaus-archive blog-wrapper blog-single page-wrapper">

    <?php while ( have_posts() ) : the_post(); ?>

    <div class="container section-title-container alt-divider"><h1 class="section-title section-title-center"><b></b><span class="section-title-main"><i class="fa-solid fa-wand-magic-sparkles" aria-hidden="true"></i><?php echo get_the_title(); ?></span><b></b></h1></div>

    <section class="container">
    <?php the_content(); ?>
    </section>

    <?php endwhile; // end of the loop. ?>

    <?php
    // Will reset previous WP Query and clear all query vars!
    wp_reset_query();
    $wp_query = new WP_Query($query_args);
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-12 col">
        <?php       
        if ( $wp_query->have_posts() ) : ?>

            <p class="lead" id="results">
                <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s publication of %s publications', 'Showing %s of %s publications', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php echo __('There', 'erua') . ' ';  printf( _n( 'is %s publication', 'are %s publications', $wp_query->found_posts, 'erua' ), '<strong>'.number_format_i18n( $wp_query->found_posts ).'</strong>' ); echo __(' in the ECOs platform', 'erua'); ?></span>
            </p>

            <div id="post-list">

            <?php /* Start the Loop */ ?>
            <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

            <?php
            $post_type = get_post_type(get_the_ID());
            switch ($post_type) {
                case 'aeiforia-project':
                    $categories_list = get_the_terms( get_the_ID(), 'aeiforia-project-category' );
                    $taxonomy = get_taxonomy('aeiforia-project-category');
                    $special = false;
                    break;
                case 'eruahaus-project':
                    $categories_list = get_the_terms( get_the_ID(), 'eruahaus-project-focus-area' );
                    $taxonomy = get_taxonomy('eruahaus-project-focus-area');
                    $special = false;
                    break;
                case 'showroom':
                    $categories_list = get_the_terms( get_the_ID(), 'showroom-category' );
                    $taxonomy = get_taxonomy('showroom-category');
                    $special = true;
                    break;
                case 'creative-blog-post':
                    $categories_list = get_the_terms( get_the_ID(), 'creative-blog-category' );
                    $taxonomy = get_taxonomy('creative-blog-category');
                    $special = false;
                    break;
                case 'hackathon':
                    $categories_list = null;
                    $taxonomy = null;
                    $special = true;
                    break;
                case 'funding-opportunity':
                    $categories_list = get_the_terms( get_the_ID(), 'funding-scientific-field' );
                    $taxonomy = get_taxonomy('funding-scientific-field');
                    $special = true;
                    break;
                case 'job-opportunity':
                    $categories_list = get_the_terms( get_the_ID(), 'job-opportunity-field' );
                    $taxonomy = get_taxonomy('job-opportunity-field');
                    $special = true;
                    break;
                case 'event':
                    $categories_list = get_the_terms( get_the_ID(), 'event-categories' );
                    $taxonomy = get_taxonomy('event-categories');
                    $special = true;
                    break;
                default:
                    $categories_list = get_the_category_list( __( ', ', 'erua' ) );
            }
            ?>
            
            <article style="margin-bottom: 30px;" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                    <header class="entry-header">
                        <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                            <h6 class="entry-category is-xsmall">
                            <?php
                            if ( $post_type === 'post' ) {
                                echo $categories_list;
                            }
                            else if ( $post_type && $taxonomy && !$special ) {
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span><a href="' . site_url('/') . $taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                    }
                                }
                            }
                            else if ( $post_type && $taxonomy && $special ) {
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span>'. $category->name .'</span>' . $separator;
                                    }
                                }
                            }
                            ?>
                            </h6>

                            <?php
                            if ( is_single() ) {
                                echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                            } else {
                                echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                            }
                            ?>

                            <div class="entry-divider is-divider small"></div>

                            <div class="entry-meta uppercase is-xsmall">
                                <?php flatsome_posted_on(); ?>
                            </div>
                        </div>
                        <?php if ( has_post_thumbnail() ) : ?>
                            <?php if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                <div class="entry-image relative">
                                    <?php get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                    <?php if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </header>
                    <?php get_template_part('template-parts/posts/content', 'default' ); ?>
                    <footer class="entry-meta clearfix<?php echo ( empty($categories_list) ) ? ' empty': ''; ?>">
                        <?php if ( 'page' !== get_post_type() ) : // Hide category and tag text for pages on Search ?>
                            <span class="cat-links">
                            <?php
                            if ( $post_type === 'post' ) {
                                printf( __( 'Posted in %1$s', 'erua' ), $categories_list );
                            }
                            else if ( $post_type && $taxonomy && !$special ) {
                                if ( !empty($categories_list) ) echo __( 'Posted in ', 'erua' );
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span><a href="' . site_url('/') . $taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                    }
                                }
                            }
                            else if ( $post_type && $taxonomy && $special ) {
                                if ( !empty($categories_list) ) echo __( 'Posted in ', 'erua' );
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span>"'. $category->name .'"</span>' . $separator;
                                    }
                                }
                            }
                            ?>
                            </span>

                            <?php
                            if ( 'post' == get_post_type() ) :
                                /* translators: used between list items, there is a space after the comma */
                                $tags_list = get_the_tag_list( '', __( ', ', 'erua' ) );
                                if ( $tags_list ) :
                            ?>
                            <span class="sep">&nbsp;|&nbsp;</span>
                            <span class="tags-links">
                                <?php printf( __( 'Tagged %1$s', 'erua' ), $tags_list ); ?>
                            </span>
                            <?php endif; // End if $tags_list ?>
                            <?php endif; // End if 'post' == get_post_type() ?>
                        <?php endif; // End if 'page' !== get_post_type() ?>
                    </footer>
                </div>
            </article>

            <?php endwhile; ?>

            <?php flatsome_posts_pagination(); ?>

            </div>

            <?php else : ?>

                <?php get_template_part( 'template-parts/posts/content','none'); ?>

            <?php endif;
        ?>
        </div>
        <!-- <div class="post-sidebar large-3 col">
            <?php //flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php //flatsome_sidebar_classes(); ?>" role="complementary">
                <?php //do_action( 'before_sidebar' ); ?>
                <?php //if ( ! dynamic_sidebar( 'eruahaus-creative-blog-sidebar' ) ) : ?>
                <?php //endif; // end sidebar widget area ?>
            </div>
            <?php //flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div> -->
    </div>

</div>

<?php
do_action( 'flatsome_after_page' );
get_footer();
