<?php
/**
 * Template Name: Job Opportunities
 * Template Post Type: page
 * 
 * This page template is solely used by the page
 * that lists the Job Opportunities.
 */

//================================================================================
// Generate CSS class for menus.
//================================================================================

/**
 * The nav_menu_css_class filter will let you add CSS classes to specific menu items.
 * We combine that with the get_page_template_slug function to fetch the page template filename, 
 * then we use that with the get_page_templates method of the theme class to get the template name 
 * as defined in the Template Name: header. 
 * 
 * Then we pass that result through sanitize_html_class to make it a valid class name. 
 * Lastly, we add it to the array of classes and return it.
 *
 * https://wordpress.stackexchange.com/a/169818
 */
function job_opportunity_archive_page_template_nav_class( $classes, $item ) {
    // only check pages
    if ( 'page' == $item->object ) {
        // if this page has a template assigned
        if( $slug = get_page_template_slug( $item->object_id ) ) {
            // get the array of filenames => template names in the current theme
            $templates = wp_get_theme()->get_page_templates();
            // if there is a template with key matching our filename
            if( isset( $templates[$slug] ) ) {
                // sanitize it and add it to the classes
                $classes[] = sanitize_html_class( $templates[$slug] );
                //$classes[] = 'current-menu-item';
            }
        }
    }
    return $classes;
}
add_filter( 'nav_menu_css_class', 'job_opportunity_archive_page_template_nav_class', 10, 2 );

//================================================================================
// Setup CSS and JS.
//================================================================================

function setup_job_opportunity_styles() {
    wp_enqueue_style( 'job-opportunities-archive-style' );
    wp_enqueue_style( 'acf-forms-style' );
}
add_action('wp_head', 'setup_job_opportunity_styles');

//================================================================================
// Setup Page Title.
//================================================================================

function setup_job_opportunity_page_title() {
    global $current_term_name, $post;

    if ( is_tax( ['job-opportunity-field'] ) ) {
        return $current_term_name . ' &#8211; ' . get_bloginfo( 'name' );
    }
    else {
        return $post->post_title . ' &#8211; ' . get_bloginfo( 'name' );
    }

}
//add_filter( 'pre_get_document_title', 'setup_job_opportunity_page_title' );

//================================================================================
// Gather page information.
//================================================================================

//$maxposts = get_option('posts_per_page');
//$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

$job_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
$job_taxonomies['job-opportunity-domain'] = get_taxonomy('job-opportunity-domain');
$job_taxonomies['job-opportunity-field'] = get_taxonomy('job-opportunity-field');
$job_taxonomies['job-opportunity-profile'] = get_taxonomy('job-opportunity-profile');
$job_taxonomies['job-opportunity-provider'] = get_taxonomy('job-opportunity-provider');
$job_taxonomies['job-opportunity-status'] = get_taxonomy('job-opportunity-status');
$job_taxonomies['job-opportunity-type'] = get_taxonomy('job-opportunity-type');

if ( is_tax( ['job-opportunity-field'] ) ) {
    $current_term_object = get_queried_object();
    $current_term_object_id = $current_term_object->ID;
    $current_term_taxonomy_name = $current_term_object->taxonomy;
    $current_term_taxonomy_name_rewrite_slug = $job_taxonomies["{$current_term_taxonomy_name}"]->rewrite['slug'];
    $current_term_id = $current_term_object->term_id;
    $current_term_slug = $current_term_object->slug;
    $current_term_name = $current_term_object->name;
    $page_title = $current_term_name;
    //$current_term_description_first_line = rtrim(strtok($current_term_object->description, "\n")); # Assign first line of category's description
    //$current_term_description_fragments = explode('# Using vector graphic:', $current_term_description_first_line);
    //$current_term_image = esc_html(trim($current_term_description_fragments[1]));

    // If viewing a specific term
    if ( $current_term_slug ) {
        wp_localize_script( 'erua-ajax-filter-jobs', 'ajax_taxonomy_archive', $current_term_slug);
        $page_url = get_term_link( $current_term_slug, $current_term_taxonomy_name);
        $page_slug = $current_term_slug;
    }
    // Else viewing all terms (404)
    else {
        wp_localize_script( 'erua-ajax-filter-jobs', 'ajax_taxonomy_archive', 'all');
        $page_url = esc_url( get_permalink( get_queried_object_id() ) );
        $page_slug = get_post_field( 'post_name', get_queried_object_id() );
    }
}
else {
    $current_term_taxonomy_name = null;
    $current_term_taxonomy_name_rewrite_slug = null;
    $current_term_id = null;
    $current_term_slug = null;
    $current_term_name = null;
    $page_url = esc_url( get_permalink( get_queried_object_id() ) );
    $page_slug = '';
    $page_title = get_post_field( 'post_title', get_queried_object_id() );

    $parent_pages = get_post_ancestors(get_queried_object_id());
    if ( $parent_pages ) {
        foreach ( $parent_pages as $pid ) {
            $slug = get_post_field( 'post_name', $pid );
            if ( $slug ) {
                $page_slug .= $slug . '/';
            }
        }
    }
    $page_slug .= get_post_field( 'post_name', get_queried_object_id() );
}

//================================================================================
// Build the Query.
//================================================================================

/**
 * These query vars must have been previously declared in the 'query_vars' filter hook,
 * in order to be recognized by WP_Query and get retrieved from the URL.
 */
$job_domains_filter = ( is_tax('job-opportunity-domain') )
    ? $current_term_id
    : ( ( get_query_var( 'job_domains' ) ) ? sanitize_text_field( get_query_var( 'job_domains' ) ) : null );

$job_fields_filter = ( is_tax('job-opportunity-field') )
    ? $current_term_id
    : ( ( get_query_var( 'job_fields' ) ) ? sanitize_text_field( get_query_var( 'job_fields' ) ) : null );

$job_profiles_filter = ( is_tax('job-opportunity-profile') )
    ? $current_term_id
    : ( ( get_query_var( 'job_profiles' ) ) ? sanitize_text_field( get_query_var( 'job_profiles' ) ) : null );

$job_provider_filter = ( is_tax('job-opportunity-provider') )
    ? $current_term_id
    : ( ( get_query_var( 'job_provider' ) ) ? sanitize_text_field( get_query_var( 'job_provider' ) ) : null );

$job_status_filter = ( is_tax('job-opportunity-status') )
    ? $current_term_id
    : ( ( get_query_var( 'job_status' ) ) ? sanitize_text_field( get_query_var( 'job_status' ) ) : null );

$job_type_filter = ( is_tax('job-opportunity-type') )
    ? $current_term_id
    : ( ( get_query_var( 'job_type' ) ) ? sanitize_text_field( get_query_var( 'job_type' ) ) : null );

$job_keyword_tag_filter = ( is_tax('job-opportunity-keyword') )
    ? $current_term_id
    : ( ( get_query_var( 'keyword_tag' ) ) ? sanitize_text_field( get_query_var( 'keyword_tag' ) ) : null );

$deadline_filter = ( get_query_var( 'deadline' ) ) ? sanitize_text_field( get_query_var( 'deadline' ) ) : null;
$keyword_filter = ( get_query_var( 'keywords' ) ) ? sanitize_text_field( get_query_var( 'keywords' ) ) : null;
// echo 'paged: ' . get_query_var( 'paged' );

$deadline_date = ( $deadline_filter ) ? DateTime::createFromFormat('Ymd', $deadline_filter) : null;
// Convert to an ISO date for the datepicker
$deadline_date = ( $deadline_date ) ? $deadline_date->format('Y-m-d') : null;

$job_domain_terms = array_filter( explode(',', $job_domains_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_field_terms = array_filter( explode(',', $job_fields_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_profile_terms = array_filter( explode(',', $job_profiles_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_provider_terms = array_filter( explode(',', $job_provider_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_status_terms = array_filter( explode(',', $job_status_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_type_terms = array_filter( explode(',', $job_type_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$job_keyword_tag_terms = array_filter( explode(',', $job_keyword_tag_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );

$query_args = getJobOpportunityQueryArguments($job_domain_terms, $job_field_terms, $job_profile_terms, $job_provider_terms, $job_status_terms, $job_type_terms, $job_keyword_tag_terms, $deadline_filter, $keyword_filter);

//================================================================================
// CONTINUE THE PAGE
//================================================================================

acf_form_head();
get_header();

// Will reset previous WP Query and clear all query vars!
wp_reset_query();
$wp_query = new WP_Query($query_args);

do_action( 'flatsome_before_page' ); ?>

<?php
// echo '<pre>';
// var_dump($job_domains_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($job_fields_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($job_profiles_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($job_provider_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($job_status_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($job_type_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($deadline_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($deadline_date);
// echo '</pre>';
// echo '<pre>';
// var_dump($keyword_filter);
// echo '</pre>';

// echo '<pre>';
// var_dump($job_domain_terms, $job_field_terms, $job_profile_terms, $job_provider_terms, $job_status_terms, $job_type_terms, $job_keyword_tag_terms, $deadline_filter, $keyword_filter);
// echo '</pre>';

// echo '<pre>';
// var_dump($query_args);
// echo '</pre>';
?>

<?php require_once __DIR__ . '/../includes/science-society/module-top-section.php'; ?>

<div id="content" class="content-area page-wrapper container">
    <section style="background-color: #fff; padding: 30px; display: flex; align-items: center;">
    <?php if ( ! $job_keyword_tag_terms ) : ?>
    <form id="opportunities-search-form" action="" method="post">
        <?php
        acf_form([
            'form' => false,
            'fields' => ['field_659a47a78b0d1', 'field_65a727b10c89a', 'field_65a728aa43959', 'field_659a4caf345ac', 'field_659a4d29dd55d', 'field_659a4d86e99f8', 'field_659a4daed2bf1', 'field_65bb28958bcd0'],
        ]);
        ?>
        <a id="reset-button" class="button alert is-outline" style="border-radius:10px;"> <span><input type="reset" value="<?php _e('RESET', 'erua'); ?>"></span> </a>
        <input type="hidden" name="_wp_http_referer" value="/job-opportunities/" />
        <input type="hidden" name="_ajax_original_page_url" value="<?php echo esc_attr($page_url); ?>" />
        <input type="hidden" name="_ajax_original_page_slug" value="<?php echo esc_attr($page_slug); ?>" />
        <input type="hidden" name="_ajax_original_term_id" value="<?php echo esc_attr($current_term_id); ?>" />
        <input type="hidden" name="_ajax_taxonomy" value="<?php echo esc_attr($current_term_taxonomy_name); ?>" />
        <input type="hidden" name="_ajax_taxonomy_rewrite_slug" value="<?php echo esc_attr($current_term_taxonomy_name_rewrite_slug); ?>" />
        <!-- <button id="filter-opportunities-button" class="button" name="conduct_jobs_search" style="left: 50%; transform: translatex(-50%); margin: 0;">Search</button> -->
        <input type="hidden" name="action" value="search_job_opportunities" />
    </form>
    <?php
    elseif ( $tag_term = get_term_by('id', $job_keyword_tag_terms[0], 'job-opportunity-keyword') ) :
        echo '<h4 class="text-center">' . __('Showing results for jobs tagged as', 'erua') . ' "' . $tag_term->name . '"' . '</h4>';
    endif;
    ?>
    </section>

    <div class="is-divider divider clearfix" style="max-width:100%;"></div>

    <div style="display: flex; flex-direction: column; margin-bottom: 60px;">
        <section class="jobs-section" class="col-inner" style="flex: 1;">
            <div id="ajax-loader" class="ajax-loader"><div></div><div></div><div></div></div>
            <div id="opportunities-container">
                    <?php require_once __DIR__ . '/../includes/science-society/job-opportunities/listings-content.php'; ?>
            </div>
        </section>
    </div>

</div>

<script>
jQuery(document).ready(function($) {

    <?php
    /*-------------------------------------------------------------------
        POPULATE FIELDS FROM QUERY URL FILTERS
    -------------------------------------------------------------------*/
    // https://stackoverflow.com/questions/41639400/loading-select2-with-a-selected-option-without-triggering-change
    // https://stackoverflow.com/questions/12889552/how-to-set-selected-value-in-multi-value-select-in-jquery-select2
    // https://select2.org/programmatic-control/add-select-clear-items#preselecting-options-in-an-remotely-sourced-ajax-select2
    ?>
    <?php if ( !empty($job_domain_terms) ) : ?>

    const domainsFilterSelect2Element = document.getElementById('acf-field_659a4caf345ac');
    <?php foreach( $job_domain_terms as $id ) : $term = get_term($id); ?>
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $id; ?>', true, true);
    $(domainsFilterSelect2Element).append(option).trigger('change');
    <?php endforeach; ?>

    <?php endif; ?>
    <?php if ( !empty($job_field_terms) ) : ?>

    const jfieldsFilterSelect2Element = document.getElementById('acf-field_65a727b10c89a');
    <?php foreach( $job_field_terms as $id ) : $term = get_term($id); ?>
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $id; ?>', true, true);
    $(jfieldsFilterSelect2Element).append(option).trigger('change');
    <?php endforeach; ?>

    <?php endif; ?>
    <?php if ( !empty($job_profile_terms) ) : ?>

    const profilesFilterSelect2Element = document.getElementById('acf-field_659a4d29dd55d');
    <?php foreach( $job_profile_terms as $id ) : $term = get_term($id); ?>
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $id; ?>', true, true);
    $(profilesFilterSelect2Element).append(option).trigger('change');
    <?php endforeach; ?>

    <?php endif; ?>
    <?php if ( !empty($job_provider_terms) && $term = get_term( $job_provider_terms[0] ) ) : ?>

    const providerFilterSelect2Element = document.getElementById('acf-field_65a728aa43959');
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $job_provider_terms[0]; ?>', true, true);
    $(providerFilterSelect2Element).append(option).trigger('change');

    <?php endif; ?>
    <?php if ( !empty($job_type_terms) && $term = get_term( $job_type_terms[0] ) ) : ?>

    const typeFilterSelect2Element = document.getElementById('acf-field_659a4d86e99f8');
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $job_type_terms[0]; ?>', true, true);
    $(typeFilterSelect2Element).append(option).trigger('change');

    <?php endif; ?>
    <?php if ( !empty($job_status_terms) && $term = get_term( $job_status_terms[0] ) ) : ?>

    const statusFilterSelect2Element = document.getElementById('acf-field_659a4daed2bf1');
    // create the option and append to Select2
    var option = new Option('<?php echo $term->name; ?>', '<?php echo $job_status_terms[0]; ?>', true, true);
    $(statusFilterSelect2Element).append(option).trigger('change');

    <?php endif; ?>
    <?php if ( !empty($deadline_filter) ) : ?>

    const deadlineFieldElement = document.querySelector('#search-by-deadline .acf-date-picker > .input.hasDatepicker');
    let deadlineFieldVal = '<?php echo $deadline_date; ?>';
    $(deadlineFieldElement).datepicker( 'setDate', new Date(deadlineFieldVal) );

    <?php endif; ?>
    <?php if ( !empty($keyword_filter) ) : ?>

    const keywordFieldElement = document.getElementById('acf-field_659a47a78b0d1');
    let keywordFieldVal = '<?php echo $keyword_filter; ?>';
    $(keywordFieldElement).val(keywordFieldVal);

    <?php endif; ?>
    <?php
    /**
     * Disable acf_form() navigate away warning.
     * https://support.advancedcustomfields.com/forums/topic/disable-acf_form-navigate-away-warning/
     */
    ?>
    jQuery(document).ready(function() {
        acf.unload.active = false;
    });

});
</script>

<?php
do_action( 'flatsome_after_page' );
get_footer();
