<?php
/**
 * Template Name: Member Contributions
 * Template Post Type: page
 *
 * This page template is solely used by the page
 * that displays a member's content to that member.
 */

//================================================================================
// Page Access Control.
//================================================================================

$login_required = get_field('page_access_requires_login');

if ( !is_admin() && $login_required ) {
    $user = wp_get_current_user();
    $allowed_user_roles = get_field('page_access_allowed_roles');
    $user_is_logged_in = is_user_logged_in();
    $user_is_allowed = true;

    if ( $user_is_logged_in && is_array($allowed_user_roles) && empty(array_intersect($allowed_user_roles, $user->roles)) ) {
        $user_is_allowed = false;
    }

    if ( !$user_is_logged_in || ( $user_is_logged_in && !$user_is_allowed && !current_user_can('administrator') ) ) {
        
        $redirect_to_url = get_field('page_access_guests_redirect_url');

        if ( isset($redirect_to_url) ) {
            wp_safe_redirect( $redirect_to_url );
            exit;
        }
        else {
            wp_safe_redirect( site_url('/') );
            exit;
        }
    }
}

//================================================================================
// SETUP.
//================================================================================

function setup_contributions_scripts() {

    // Enqueue the script in the footer!
    wp_enqueue_script('erua-ajax-refresh-own-content', get_stylesheet_directory_uri() . '/assets/js/ajax-refresh-own-content.js', '', '', true);

    // Get the current query vars at the time the script is called
    global $wp_query;
    $qvars = $wp_query->query;
    //$qvars['testing'] = 'hmm';
    // Push the query vars to the above script
    wp_localize_script('erua-ajax-refresh-own-content', 'ajax_query_data', ['query' => $qvars]);

    // $data_to_hash = date('d/m/Y h:i:s a', time()) . wp_get_current_user()->ID . wp_get_current_user()->user_pass;
    // $test_nonce = base64_encode(hash('sha256', '', false));

    $params = [
        '_ajax_url' => admin_url('admin-ajax.php'),
        '_ajax_action' => 'the_own_content_syncing', # load function hooked to: "wp_ajax_*" action hook
        //'_ajax_post_id' => get_the_ID(),
        /**
         * The nonce is generated based on the current time, 
         * the provided string argument, and the current user ID.
         * https://codex.wordpress.org/Function_Reference/wp_create_nonce
         */
        '_ajax_nonce' => wp_create_nonce('account_own_content_refreshing_nonce'),
    ];
    wp_localize_script('erua-ajax-refresh-own-content', 'ajax_object', $params);

}
add_action('wp_enqueue_scripts', 'setup_contributions_scripts');

//================================================================================
// Get header.
//================================================================================

get_header();

//================================================================================
// Get Query Vars.
//================================================================================

$user_post_type = ( get_query_var( 'content_type' ) ) ? sanitize_text_field( get_query_var( 'content_type' ) ) : null;

// echo '<pre>';
// var_dump($user_post_type);
// echo '</pre>';

//================================================================================
// Display page.
//================================================================================
do_action( 'flatsome_before_page' );
?>

<div id="content" role="main" class="content-area">

    <div class="container" style="padding-bottom: 20px;">
    <?php while ( have_posts() ) : the_post(); ?>

        <?php the_content(); ?>

    <?php endwhile; // end of the loop. ?>
    </div>
    <section class="contributions-section">
        <div id="ajax-loader" class="ajax-loader"><div></div><div></div><div></div></div>
        <?php
        if ( is_user_logged_in() && $user_post_type && post_type_exists($user_post_type) ) {
            // Get all contributions submitted by the user
            $query_args = [
                'post_type' => $user_post_type,
                //'post_status' => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit'],
                'post_status' => 'publish',
                'orderby'     => 'date',
                'numberposts' => -1,
                //'numberposts' => '5',
                'author' => wp_get_current_user()->ID,
                'posts_per_page' => 10, # get_option('posts_per_page'),
                'paged' => ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1,
            ];
            // Will reset previous WP Query and clear all query vars!
            wp_reset_query();
            $wp_query = new WP_Query($query_args);
        }
        ?>
        <div id="contributions-wrapper" class="container">
        <?php require_once __DIR__ . '/../template-parts/user-contributions.php'; ?>
        </div>
    </section>
</div>

<?php
do_action( 'flatsome_after_page' );
//================================================================================
// Get footer.
//================================================================================

get_footer();
