<?php
/**
 * The blog template file.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

global $wp_query;

if ( isset( $wp_query ) && (bool) $wp_query->is_posts_page ) {
    acf_form_head();
}

get_header();

?>

<div id="content" class="blog-wrapper blog-archive page-wrapper main-blog">

        <?php require_once __DIR__ . '/includes/news-events/module-top-section.php'; ?>

        <?php
        if ( isset( $wp_query ) && (bool) $wp_query->is_posts_page ) {
            echo '<header class="entry-header container" style="text-align: center; margin: 40px auto 60px auto;">
            <div class="container section-title-container alt-divider"><h1 class="section-title section-title-center"><b></b><span class="section-title-main"><i class="fa-solid fa-rss" aria-hidden="true"></i>' . get_the_title( get_option('page_for_posts', true) ) . '</span><b></b></h1></div>
            ' . do_shortcode('[block id="news-page-text"]') . '
            <p class="lead jump-to-form">
                <a href="#publish" class="button"><span class="down-arrow"></span>Add your news!</a>
            </p>
            <hr>
        </header>';
        }
        ?>

        <?php get_template_part( 'template-parts/posts/layout', get_theme_mod('blog_layout','right-sidebar') ); ?>

        <?php if ( isset( $wp_query ) && (bool) $wp_query->is_posts_page ) : ?>
            <hr style="margin: 40px auto;" class="container">
            <div id="publish" class="container">
            <?php
            if ( is_user_logged_in() ) {
                echo '<h2 id="submit-news" class="acf-form-heading">' . __('Submit something in the News section', 'erua') . '</h2>';
                echo do_shortcode( '[news-form]' );
            }
            else {
                $login_url = site_url() . '/login/'; # get_permalink( get_option('woocommerce_myaccount_page_id') );
                echo '<a href="' . $login_url . '" id="logreg">Login or register to submit a post</a>';
            }
            ?>
            </div>
            <?php
            /**
             * Replace ajax-loaded ACF strings with our preferred translated ones.
             */
            ?>
            <script>
            jQuery(document).ajaxComplete(function () {

                jQuery('.acf-error-message p').each(function() {
                    var text = jQuery(this).text();
                    var textReplacement = '<?php _e('(required field)', 'erua'); ?>';
                    text = text.replace('value is required', textReplacement);
                    jQuery(this).text(text);
                });

            });
            </script>
            <script>
                jQuery( document ).ready(function() {
                    jQuery(function() {
                        jQuery('a[href*=#publish]').on('click', function(e) {
                            e.preventDefault();
                            jQuery('html, body').animate({ scrollTop: jQuery(jQuery(this).attr('href')).offset().top}, 500, 'linear');
                        });
                    });
                });
            </script>
            <?php
            /**
             * Disable acf_form() navigate away warning.
             * https://support.advancedcustomfields.com/forums/topic/disable-acf_form-navigate-away-warning/
             */
            ?>
            <script>
            jQuery(document).ready(function() {
                acf.unload.active = false;
            });
            </script>
        <?php endif; ?>

</div>

<?php get_footer(); ?>
