<?php

/**
 * Custom Archives widget.
 * 
 * Resources:
 * https://lonewolfonline.net/creating-wordpress-widgets/
 * https://www.hostinger.com/tutorials/how-to-create-custom-widget-in-wordpress
 */
class Custom_Archives_Widget extends WP_Widget_Archives {

    public function widget( $args, $instance ) {
		$default_title = __( 'Archives' );
		$title         = ! empty( $instance['title'] ) ? $instance['title'] : $default_title;

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$count    = ! empty( $instance['count'] ) ? '1' : '0';
		$dropdown = ! empty( $instance['dropdown'] ) ? '1' : '0';

		echo $args['before_widget'];

		if ( 'aeiforia-project' === get_post_type() ) {
			$post_type = 'aeiforia-project';
		}
		else if ( 'eruahaus-project' === get_post_type() ) {
			$post_type = 'eruahaus-project';
		}
		else if ( 'showroom' === get_post_type() ) {
			$post_type = 'showroom';
		}
		else if ( 'creative-blog-post' === get_post_type() ) {
			$post_type = 'creative-blog-post';
		}
		else if ( 'hackathon' === get_post_type() ) {
			$post_type = 'hackathon';
		}
		else if ( 'funding-opportunity' === get_post_type() ) {
			$post_type = 'funding-opportunity';
		}
		else if ( 'job-opportunity' === get_post_type() ) {
			$post_type = 'job-opportunity';
		}
		else {
			$post_type = 'post';
		}

		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		if ( $dropdown ) {
			$dropdown_id = "{$this->id_base}-dropdown-{$this->number}";
			?>
		<label class="screen-reader-text" for="<?php echo esc_attr( $dropdown_id ); ?>"><?php echo $title; ?></label>
		<select id="<?php echo esc_attr( $dropdown_id ); ?>" name="archive-dropdown">
			<?php
			/**
			 * Filters the arguments for the Archives widget drop-down.
			 *
			 * @since 2.8.0
			 * @since 4.9.0 Added the `$instance` parameter.
			 *
			 * @see wp_get_archives()
			 *
			 * @param array $args     An array of Archives widget drop-down arguments.
			 * @param array $instance Settings for the current Archives widget instance.
			 */
			$dropdown_args = apply_filters(
				'widget_archives_dropdown_args',
				array(
					'type'            => 'monthly',
					'format'          => 'option',
					'show_post_count' => $count,
                    'post_type'   => $post_type,
				),
				$instance
			);

			switch ( $dropdown_args['type'] ) {
				case 'yearly':
					$label = __( 'Select Year' );
					break;
				case 'monthly':
					$label = __( 'Select Month' );
					break;
				case 'daily':
					$label = __( 'Select Day' );
					break;
				case 'weekly':
					$label = __( 'Select Week' );
					break;
				default:
					$label = __( 'Select Post' );
					break;
			}

			$type_attr = current_theme_supports( 'html5', 'script' ) ? '' : ' type="text/javascript"';
			?>

			<option value=""><?php echo esc_html( $label ); ?></option>
			<?php wp_get_archives( $dropdown_args ); ?>

		</select>

<script<?php echo $type_attr; ?>>
/* <![CDATA[ */
(function() {
	var dropdown = document.getElementById( "<?php echo esc_js( $dropdown_id ); ?>" );
	function onSelectChange() {
		if ( dropdown.options[ dropdown.selectedIndex ].value !== '' ) {
			document.location.href = this.options[ this.selectedIndex ].value;
		}
	}
	dropdown.onchange = onSelectChange;
})();
/* ]]> */
</script>
			<?php
		} else {
			$format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

			/** This filter is documented in wp-includes/widgets/class-wp-nav-menu-widget.php */
			$format = apply_filters( 'navigation_widgets_format', $format );

			if ( 'html5' === $format ) {
				// The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
				$title      = trim( strip_tags( $title ) );
				$aria_label = $title ? $title : $default_title;
				echo '<nav aria-label="' . esc_attr( $aria_label ) . '">';
			}
			?>

			<ul>
				<?php
				wp_get_archives(
					/**
					 * Filters the arguments for the Archives widget.
					 *
					 * @since 2.8.0
					 * @since 4.9.0 Added the `$instance` parameter.
					 *
					 * @see wp_get_archives()
					 *
					 * @param array $args     An array of Archives option arguments.
					 * @param array $instance Array of settings for the current widget.
					 */
					apply_filters(
						'widget_archives_args',
						array(
							'type'            => 'monthly',
							'show_post_count' => $count,
                            'post_type'   => $post_type,
						),
						$instance
					)
				);
				?>
			</ul>

			<?php
			if ( 'html5' === $format ) {
				echo '</nav>';
			}
		}

		echo $args['after_widget'];
	}

}
