<?php
/**
 * This file contains various theme configurations.
 * Setup of styles (.css), scripts (.js), languages, features, menus, widgets etc.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * TODO AJAX rate limiting
 * https://medium.com/@alejandro-ao/how-to-do-ajax-in-wordpress-a826f9fde4d5
 * https://getshieldsecurity.com/blog/shield-rate-limiting-protection-wordpress/
 * https://stackoverflow.com/questions/43403451/php-server-side-rate-limit-on-ajax-callbacks
 */

//================================================================================
// THEME GLOBAL VARIABLES
//================================================================================

$EMAIL_SIGNATURE_MESSAGE = __('Kind Regards,<br />ECOs Team', 'erua');
$DEFAULT_IMAGE = 13;
$PROJECT_DEFAULT_THUMBNAIL_IMAGE = 13; # @ 'dfi_thumbnail_id' filter
//$FILEBIRD_USER_AVATARS_FOLDER = 10;
$FILEBIRD_BP_MEMBER_MEDIA_FOLDER = 10;
$FILEBIRD_BP_GROUP_MEDIA_FOLDER = 19;

$FILEBIRD_ERUAHAUS_PROJECTS_FOLDER = 20;
$FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER = 21;
$FILEBIRD_ERUAHAUS_PROJECTS_FEATURED_IMAGES_FOLDER = 23;
$FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER = 25;

$FILEBIRD_ERUAHAUS_SHOWROOM_FEATURED_IMAGES_FOLDER = 27;
$FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER = 28;
$FILEBIRD_ERUAHAUS_SHOWROOM_GALLERY_IMAGES_FOLDER = 29;
$FILEBIRD_ERUAHAUS_SHOWROOM_VIDEOS_FOLDER = 30;

$FILEBIRD_ERUAHAUS_CREATIVE_BLOG_FEATURED_IMAGES_FOLDER = 31;
$FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER = 32;

$FILEBIRD_EVENTS_FOLDER = 15;
$FILEBIRD_POSTS_FOLDER = 9;
$FILEBIRD_BLOG_MEDIA_FOLDER = 14;

//================================================================================
// THEME STYLES & SCRIPTS
//================================================================================

/**
 * Enqueue styles for child theme
 */
function erua_enqueue_styles() {

    global $wp_query;
    global $post;

    // Load child theme's main stylesheet
    //wp_enqueue_style( 'erua-style', get_stylesheet_directory_uri() . '/style.css', array( 'flatsome-main' ) );

    // Replace font awesome plugin by manually adding these
    // <link rel='stylesheet' id='font-awesome-official-css' href='https://use.fontawesome.com/releases/v6.4.2/css/all.css' type='text/css' media='all' integrity="sha384-blOohCVdhjmtROpu8+CfTnUWham9nkX7P7OZQMst+RUnhtoY/9qemFAkIKOYxDI3" crossorigin="anonymous" />
    // <link rel='stylesheet' id='font-awesome-official-v4shim-css' href='https://use.fontawesome.com/releases/v6.4.2/css/v4-shims.css' type='text/css' media='all' integrity="sha384-IqMDcR2qh8kGcGdRrxwop5R2GiUY5h8aDR/LhYxPYiXh3sAAGGDkFvFqWgFvTsTd" crossorigin="anonymous" />


    // Register Swiper stylesheet making it available to be enqueued by whatever page needs it:
    wp_register_style( 'swiper-style', get_stylesheet_directory_uri() . '/assets/css/libraries/swiper-bundle.min.css' );
    wp_register_style( 'swiper-slider-common', get_stylesheet_directory_uri() . '/assets/css/shortcodes/swiper-slider-common.css' );

    // Register various page stylesheets
    wp_register_style( 'aeiforia-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/aeiforia-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'eruahaus-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/eruahaus-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'eruahaus-showroom-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/eruahaus-showroom-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'eruahaus-creative-blog-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/eruahaus-creative-blog-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'eruahaus-eruaner-projects-style', get_stylesheet_directory_uri() . '/assets/css/eruahaus-eruaner-projects.css', array( 'flatsome-style' ) );
    wp_register_style( 'funding-opportunities-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/funding-opportunities-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'job-opportunities-archive-style', get_stylesheet_directory_uri() . '/assets/css/archives/job-opportunities-archive.css', array( 'flatsome-style' ) );
    wp_register_style( 'scafe-style', get_stylesheet_directory_uri() . '/assets/css/pages/scafe.css', array( 'flatsome-style' ) );
    wp_register_style( 'spotlights-style', get_stylesheet_directory_uri() . '/assets/css/pages/spotlights.css', array( 'flatsome-style' ) );
    wp_register_style( 'previous-hackathons-style', get_stylesheet_directory_uri() . '/assets/css/shortcodes/previous-hackathons.css' );
    wp_register_style( 'featured-hackathons-style', get_stylesheet_directory_uri() . '/assets/css/shortcodes/featured-hackathons.css' );
    wp_register_style( 'account-user-contributions-style', get_stylesheet_directory_uri() . '/assets/css/pages/user-contributions.css', array( 'flatsome-style' ) );
    wp_register_style( 'acf-forms-style', get_stylesheet_directory_uri() . '/assets/css/acf-form-styles-collection.css', array( 'flatsome-style' ) );
    wp_register_style( 'events-calendar-style', get_stylesheet_directory_uri() . '/assets/css/events-calendar.css', array( 'flatsome-style' ) );

    if ( isset( $wp_query ) && (bool) $wp_query->is_posts_page ) {
        wp_enqueue_style( 'acf-forms-style' );
    }

    if ( is_front_page() ) {
        wp_enqueue_style( 'homepage-style', get_stylesheet_directory_uri() . '/assets/css/pages/home.css', array( 'flatsome-style' ) );
    }

    if ( is_search() ) {
        wp_enqueue_style( 'search-results-style', get_stylesheet_directory_uri() . '/assets/css/search.css', array( 'flatsome-style' ) );
    }

    if ( is_page(['events', 'showroom-events']) ) {
        //wp_enqueue_style( 'acf-forms-style' );
        wp_enqueue_style( 'events-calendar-style' );
    }

    if ( is_page() && isset($post->ID) && get_field('acf_form_head_enabled', $post->ID) && !wp_style_is( 'acf-forms-style', 'enqueued' ) ) {
        wp_enqueue_style( 'acf-forms-style' );
    }

    if ( isset($post->ID) && ( $post->ID === get_field('science_cafe_page', 'option') || $post->ID === 1869 ) ) {
        wp_enqueue_style( 'scafe-style' );
    }

    if ( is_user_logged_in() && isset($post->ID) && $post->ID === get_field('my_content_page', 'option') ) {
        wp_enqueue_style( 'account-user-contributions-style' );
    }

    if ( is_post_type_archive('creative-blog-post') ) {
    //if ( is_post_type_archive('creative-blog-post') || is_tax( ['creative-blog-category', 'creative-blog-tag'] ) ) {
        wp_enqueue_style( 'acf-forms-style' );
        wp_enqueue_style( 'eruahaus-creative-blog-archive-style' );
    }

    if ( is_singular( 'aeiforia-project' ) ) {
        wp_enqueue_style( 'single-aeiforia-project-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-aeiforia-project.css', array( 'flatsome-style' ) );
        wp_enqueue_style( 'swiper-style' );
    }

    if ( is_singular( 'eruahaus-project' ) ) {
        wp_enqueue_style( 'single-eruahaus-project-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-eruahaus-project.css', array( 'flatsome-style' ) );
        wp_enqueue_style( 'swiper-style' );
    }

    if ( is_singular( 'showroom' ) ) {
        wp_enqueue_style( 'single-showroom-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-showroom.css', array( 'flatsome-style' ) );
        wp_enqueue_style( 'swiper-style' );
    }

    if ( is_singular( 'creative-blog-post' ) ) {
        wp_enqueue_style( 'single-creative-blog-post-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-creative-blog-post.css', array( 'flatsome-style' ) );
        //wp_enqueue_style( 'swiper-style' );
    }

    if ( is_singular( 'hackathon' ) ) {
        wp_enqueue_style( 'single-hackathon-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-hackathon.css', array( 'flatsome-style' ) );
    }

    if ( is_singular( 'funding-opportunity' ) ) {
        wp_enqueue_style( 'single-funding-opportunity-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-funding-opportunity.css', array( 'flatsome-style' ) );
    }

    if ( is_singular( 'job-opportunity' ) ) {
        wp_enqueue_style( 'single-job-opportunity-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-job-opportunity.css', array( 'flatsome-style' ) );
    }

    if ( is_singular( 'post' ) ) {
        wp_enqueue_style( 'single-post-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-post.css', array( 'flatsome-style' ) );
    }

    if ( is_singular( 'event' ) ) {
        wp_enqueue_style( 'single-event-style', get_stylesheet_directory_uri() . '/assets/css/singles/single-event.css', array( 'flatsome-style' ) );
    }

}
add_action( 'wp_enqueue_scripts', 'erua_enqueue_styles' );

/**
 * Enqueue scripts for child theme
 *
 * https://stackoverflow.com/questions/23507179/wp-dequeue-script-for-child-theme-to-replace-script/29193637
 */
function erua_enqueue_scripts() {

    global $post;

    // Enqueue child theme script
    wp_enqueue_script( 'erua-script', get_stylesheet_directory_uri() . '/assets/js/theme.js', ['jquery'], false, true );

    /**
     * Parent scripts and styles should be deregistered AND and dequeued to remove them completely from queue.
     */
    wp_dequeue_script('flatsome-live-search');
    wp_deregister_script( 'flatsome-live-search' );

    // Enqueue replacement script for live search
	$theme   = wp_get_theme( get_template() );
	$version = $theme->get( 'Version' );
    wp_enqueue_script( 'flatsome-live-search', get_stylesheet_directory_uri() . '/assets/js/flatsome-live-search.js', false, $version, true );

    // Register Swiper script making it available to be enqueued by whatever page needs it:
    wp_register_script( 'swiper-script', get_stylesheet_directory_uri() . '/assets/js/libraries/swiper-bundle.min.js', ['jquery'], false, true );

    wp_register_script( 'acf-forms-script', get_stylesheet_directory_uri() . '/assets/js/acf-forms-common.js', ['jquery'], false, true );
    wp_register_script( 'scafe-script', get_stylesheet_directory_uri() . '/assets/js/scafe.js', ['jquery'], false, true );

    if ( is_page() && get_field('acf_form_head_enabled', $post->ID) && !wp_script_is( 'acf-forms-style', 'enqueued' ) ) {
        wp_enqueue_script( 'acf-forms-script' );
    }

    if ( isset($post->ID) && $post->ID === get_field('science_cafe_page', 'option') || $post->ID === 1869 ) {
        wp_enqueue_script( 'scafe-script' );
    }

    if ( is_post_type_archive('creative-blog-post') ) {
    //if ( is_post_type_archive('creative-blog-post') || is_tax( ['creative-blog-category', 'creative-blog-tag'] ) ) {
        wp_enqueue_script( 'acf-forms-script' );
    }

    // Register Magic Grid script making it available to be enqueued by whatever page needs it:
    //wp_register_script( 'masonry-script', get_stylesheet_directory_uri() . '/assets/js/libraries/magic-grid.min.js', [], false, true  );

    if ( is_singular( ['aeiforia-project', 'eruahaus-project', 'showroom'] ) ) {
        wp_enqueue_script( 'swiper-script' );

        $custom_js = "
        <script>
        var swiperMedia = new Swiper('.swiper-container.media', {
            // Default parameters
            slidesPerView: 1,
            //slidesPerGroup: 3,
            spaceBetween: 10, // -50
            grabCursor: true,
            // autoplay: {
            //     delay: 5000,
            // },
            // speed: 1000,
            pagination: {
                el: '.swiper-pagination.media',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next.media',
                prevEl: '.swiper-button-prev.media',
            },
            // Responsive breakpoints (when window width is >= x pixels)
            breakpoints: {
                640: {
                    slidesPerView: '1',
                    spaceBetween: 10,
                },
                1024: {
                    slidesPerView: '1',
                    spaceBetween: 20,
                },
                1280: {
                    slidesPerView: '1',
                    spaceBetween: 30,
                },
            }
        });
        </script>";

        wp_add_inline_script( 'swiper-script', $custom_js );
    }
}
add_action( 'wp_enqueue_scripts', 'erua_enqueue_scripts', 20 );

//================================================================================
// THEME FEATURES
//================================================================================

/**
 * Remove functionality for specific post types
 */
function erua_remove_custom_post_features() {
    remove_post_type_support( 'post', 'comments' );
    remove_post_type_support( 'post', 'trackbacks' );
}
add_action( 'init', 'erua_remove_custom_post_features' );

//================================================================================
// USERS
//================================================================================

/**
 * Change 'author' to a custom author base.
 * Save/flush permalinks to apply the change.
 *
 * https://weusewp.com/tutorial/change-author-url-slug-base/
 * https://stackoverflow.com/questions/19884216/wordpress-user-permalink-change-issue
 */
function erua_new_author_base() {
    global $wp_rewrite;
    $myauthor_base = 'user';
    $wp_rewrite->author_base = $myauthor_base;
    //$wp_rewrite->author_structure = $wp_rewrite->author_base . '/%author%';
}
//add_action('init', 'erua_new_author_base');

//================================================================================
// AVATARS
//================================================================================

/**
 * Use ACF image field as avatar
 * 
 * https://developer.wordpress.org/reference/hooks/get_avatar/
 * https://thestizmedia.com/acf-pro-simple-local-avatars/
 * https://wordpress.stackexchange.com/questions/213892/get-avatar-filter-in-wordpress-4-4-how-to-filter-properly
 * 
 * Alternatively use this plugin:
 * https://wordpress.org/plugins/simple-local-avatars/
 */
function erua_acf_profile_avatar( $avatar, $id_or_email, $size, $default, $alt, $args ) {

    if ( ! get_option( 'show_avatars' ) ) {
        return false;
    }

    // $default = get_option( 'avatar_default', 'mysteryman' );

    // // Properly show the 32x32 Avatars and Gravatars on the options-discussion.php page
    if ( is_admin() ) {
        $screen = get_current_screen();
        if ( is_object($screen) && in_array( $screen->id, array( 'options-discussion' ) ) && in_array( $size, array( '32' ) ) ) {
            return $avatar;
        }
    }

    /**
     * The get_avatar filter is a little tricky, since it needs to get a user by id_or_email.
     * We need to account for both, so the $user line does all of the logic for that.
     */
    $user = '';

    // Get user by id or email
    if ( is_numeric( $id_or_email ) ) {

        $id   = (int) $id_or_email;
        $user = get_user_by( 'id' , $id );

    } elseif ( is_object( $id_or_email ) ) {

        if ( ! empty( $id_or_email->user_id ) ) {
            $id   = (int) $id_or_email->user_id;
            $user = get_user_by( 'id' , $id );
        }

    } else {
        $user = get_user_by( 'email', $id_or_email );
    }

    if ( ! $user ) {
        return $avatar;
    }

    // Get the user id
    $user_id = $user->ID;

    // Get the file id (pulling in our local avatar image, if there's one)
    $image_id = get_user_meta( $user_id, 'user_profile_image', true ); # MODIFY FIELD NAME

    // Bail if we don't have a local avatar
    if ( ! $image_id ) {
        return $avatar;
    }

    // Get the image url
    $image_url  = wp_get_attachment_image_src( $image_id, 'thumbnail' ); # Set image size by name
    // Get the file url (sets our default/fallback avatar for users that don’t upload one)
    $avatar_url = $image_url[0];
    // Get the img markup
    $avatar = '<img alt="' . $alt . '" src="' . $avatar_url . '" class="avatar avatar-' . $size . ' photo" height="' . $size . '" width="' . $size . '"/>';

    // Return our new avatar
    return $avatar;
}
//add_filter('get_avatar', 'erua_acf_profile_avatar', 10, 6);

//================================================================================
// TRANSLATIONS
//================================================================================

/**
 * Setup theme's languages folder to store translations,
 * and load .mo (Machine Object) language files for internationalization.
 */
function erua_languages_setup() {
    // https://wordpress.stackexchange.com/questions/70676/how-to-check-if-i-am-in-admin-ajax-php/70677
    //if ( is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) {
    if ( wp_doing_ajax() ) {
        $locale = get_locale();
        //$locale = 'el';
        // https://stackoverflow.com/questions/41731657/in-a-wordpress-plugin-admin-ajax-call-which-is-the-way-of-using-the-sites-loca
        add_filter('determine_locale', function()use($locale){ return $locale; });
    }
    // load translation file for the child theme
    load_child_theme_textdomain('erua', get_stylesheet_directory() . '/languages');
}
add_action('after_setup_theme', 'erua_languages_setup');

//================================================================================
// TAXONOMIES
//================================================================================

/**
 * -  Wordpress get_categories() order by term_order -
 * This code forces WP to use the orderby => term_order argument in your term query.
 * 
 * https://www.anycodings.com/questions/wordpress-getcategories-order-by-termorder
 */
function wpcf_filter_terms_order( $orderby, $query_vars, $taxonomies ) {
    return $query_vars['orderby'] == 'term_order' ? 'term_order' : $orderby;
}
add_filter( 'get_terms_orderby', 'wpcf_filter_terms_order', 10, 3 );

//================================================================================
// TAGS
//================================================================================

/**
 * Limit tags in legacy tag cloud widget
 * 
 * https://wordpress.stackexchange.com/questions/155206/edit-tag-cloud-widget-number
 * https://developer.wordpress.org/reference/functions/wp_tag_cloud/#source
 * https://craftweeks.com/en/change-font-size-of-gutenberg-tag-cloud-in-wordpress/
 * https://gist.github.com/iworks/4041f5af509a90541c6413d25289d483
 */
function erua_widget_tag_cloud_args( $args ) {
    $args['number'] = 25;
    $args['order'] = 'RAND';
    $args['ignore_term_order'] = true;
    return $args;
}
add_filter('widget_tag_cloud_args', 'erua_widget_tag_cloud_args', 10, 1);

/**
* Limit tags in single post
*/
function erua_limit_to_five_tags($terms) {
    return array_slice($terms,0,5,true);
}
//add_filter('term_links-post_tag','erua_limit_to_five_tags');

/**
* Limit tags in product tag cloud widget
* https://woocommerce.github.io/code-reference/classes/WC-Widget-Product-Tag-Cloud.html
* https://stackoverflow.com/questions/56487076/show-most-popular-woocommerce-product-tags-in-product-tag-cloud-widget
*/
function woocommerce_product_tag_cloud_widget_filter($args) {
    $my_args = array(
        'smallest' => 14, // size of least used tag
        'largest' => 14, // size of most used tag
        //'format' => 'list', 
        'taxonomy' => 'product_tag', 
        'unit' => 'px', // unit for sizing the tags
        'show_count' => 0,
        'number' => 25, // displays at most 25 tags
        'orderby' => 'name', // order tags by 'name' or 'count'
        'order' => 'RAND', // order tags by ascending order, 'ASC', 'DESC', or 'RAND'
    );

    $args = wp_parse_args( $args, $my_args );

    return $args;
}
//add_filter('woocommerce_product_tag_cloud_widget_args', 'woocommerce_product_tag_cloud_widget_filter');

//================================================================================
// MODULE LANDING PAGES
//================================================================================

/**
 * Add States (custom labels) to specified WordPress Pages
 *
 * https://wordpress.stackexchange.com/questions/240081/change-wordpress-post-state-in-admin-area
 */
function erua_custom_post_states( $states, $post ) { 

    $aeiforia_landing_page_id = ( get_field('aeiforia_landing_page', 'option') ) ?? null;
    $eruahaus_landing_page_id = ( get_field('eruahaus_landing_page', 'option') ) ?? null;
    $eruahaus_project_creation_landing_page_id = ( get_field('eruahaus_project_creation_landing_page', 'option') ) ?? null;
    $eruahaus_eruaner_membership_request_page_id = ( get_field('eruahaus_eruaner_membership_request_page', 'option') ) ?? null;
    $eruahaus_showroom_page_id = ( get_field('eruahaus_showroom_page', 'option') ) ?? null;
    $eruahaus_showroom_presentation_creation_page_id = ( get_field('eruahaus_showroom_presentation_creation_page', 'option') ) ?? null;
    $partnerships_landing_page_id = ( get_field('partnerships_landing_page', 'option') ) ?? null;
    $society_landing_page_id = ( get_field('society_landing_page', 'option') ) ?? null;
    $science_shop_page_id = ( get_field('science_shop_page', 'option') ) ?? null;
    $science_cafe_page_id = ( get_field('science_cafe_page', 'option') ) ?? null;
    $hackathons_page_id = ( get_field('hackathons_page', 'option') ) ?? null;
    $funding_opportunities_page_id = ( get_field('funding_opportunities_page', 'option') ) ?? null;
    $job_opportunities_page_id = ( get_field('job_opportunities_page', 'option') ) ?? null;
    $news_events_landing_page_id = ( get_field('news_events_landing_page', 'option') ) ?? null;
    $user_content_page_id = ( get_field('my_content_page', 'option') ) ?? null;

    if ( 'page' == get_post_type( $post->ID ) ) {
        if ( $post->ID === $aeiforia_landing_page_id ) {
            $states[] = __('AEIFORIA HOME', 'erua');
        }
        else if ( $post->ID === $eruahaus_landing_page_id ) {
            $states[] = __('ERUAHAUS HOME', 'erua');
        }
        else if ( $post->ID === $eruahaus_project_creation_landing_page_id ) {
            $states[] = __('ERUAHAUS PROJECT/TEAM CREATION FORM', 'erua');
        }
        else if ( $post->ID === $eruahaus_eruaner_membership_request_page_id ) {
            $states[] = __('ERUAHAUS ERUANER MEMBERSHIP REQUEST FORM', 'erua');
        }
        else if ( $post->ID === $eruahaus_showroom_page_id ) {
            $states[] = __('ERUAHAUS SHOWROOM', 'erua');
        }
        else if ( $post->ID === $eruahaus_showroom_presentation_creation_page_id ) {
            $states[] = __('ERUAHAUS SHOWROOM PRESENTATION CREATION FORM', 'erua');
        }
        else if ( $post->ID === $society_landing_page_id ) {
            $states[] = __('SCIENCE & SOCIETY HOME', 'erua');
        }
        else if ( $post->ID === $partnerships_landing_page_id ) {
            $states[] = __('PARTNERSHIPS HOME', 'erua');
        }
        else if ( $post->ID === $news_events_landing_page_id ) {
            $states[] = __('NEWS-EVENTS HOME', 'erua');
        }
        else if ( $post->ID === $user_content_page_id ) {
            $states[] = __('USER ACCOUNT - MY CONTENT', 'erua');
        }
        else if ( $post->ID === $science_cafe_page_id ) {
            $states[] = __('SCIENCE CAFES', 'erua');
        }
        else if ( $post->ID === $hackathons_page_id ) {
            $states[] = __('HACKATHONS', 'erua');
        }
        else if ( $post->ID === $funding_opportunities_page_id ) {
            $states[] = __('FUNDING OPPORTUNITIES', 'erua');
        }
        else if ( $post->ID === $job_opportunities_page_id ) {
            $states[] = __('JOB OPPORTUNITIES', 'erua');
        }
    }

    return $states;
}
add_filter('display_post_states', 'erua_custom_post_states', 10, 2);

//================================================================================
// MENUS
//================================================================================

/**
* Register menus.
* Use register_nav_menus() for multiple menus.
*/
register_nav_menu( 'side-nav-menu', __( 'Side Navigation Menu', 'erua' ) );
