<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * We'll send emails to the following entities, 
 * after a new event has been submitted.
 * 
 * 1) Applicant
 * 
 * We'll notify the applicant (creator of the event) 
 * that his event was submitted successfully.
 * 
 * 2) Administrators
 */
function send_emails_after_event_creation($post_id) {

    global $EMAIL_SIGNATURE_MESSAGE;

    //$event_title = html_entity_decode( get_the_title( $post_id ), ENT_COMPAT, 'UTF-8' );
    $event_title = get_the_title($post_id);
    $applicant_name = get_field('event_applicant_name', $post_id);
    $applicant_email = sanitize_email( get_field('event_applicant_email', $post_id) );
    $unique_token = get_field('event_unique_token', $post_id);
    $date_created = get_field('event_date_created', $post_id);

    $headers = array(
        "MIME-Version: 1.0",
        "Content-Type: text/html; charset=UTF-8"
    );

    $to = $applicant_email;
    $subject = __('Successful Event Submission', 'erua');

    $message = __('Dear', 'erua') . ' ' . $applicant_name . ',';
    $message .= '<br /><br />';
    $message .= __('Your event has been successfully submitted. You can view your event here:', 'erua');
    $message .= '<br />';
    $message .= '<a href="' . get_post_permalink($post_id) . '?uid=' . $unique_token . '">' . get_post_permalink($post_id) . '?uid=' . $unique_token . '</a>';
    $message .= '<br /><br />';
    $message .= $EMAIL_SIGNATURE_MESSAGE;

    // Send email to the applicant.
    //wp_mail( $to, $subject, $message, $headers );


    $subject = __('New Event Submission', 'erua');

    // Find all users that are administrators
    $administrators_query = new WP_User_Query( array( 'role' => 'administrator' ) );

    // Administrators Loop
    if ( ! empty( $administrators_query->get_results() ) ) {
        foreach ( $administrators_query->get_results() as $administrator ) {

            //$message .= '<a href="' . get_edit_post_link($post_id) . '">' . get_edit_post_link($post_id) . '</a>';

            $message = __('Dear', 'erua') . ' ' . $administrator->display_name . ',';
            $message .= '<br /><br />';
            $message .= __('A new event has been successfully submitted. You can view the event here:', 'erua');
            $message .= '<br />';
            //$message .= '<a href="' . get_post_permalink($post_id) . '?uid=' . $unique_token . '">' . get_post_permalink($post_id) . '?uid=' . $unique_token . '</a>';
            $message .= '<a href="' . get_admin_url() . 'post.php?post=' . $post_id . '&action=edit">' . get_admin_url() . 'post.php?post=' . $post_id . '&action=edit</a>';
            $message .= '<br /><br />';
            $message .= __('Please log in to the ECOs platform in order to approve and/or edit the event.');
            $message .= '<br /><br />';
            $message .= $EMAIL_SIGNATURE_MESSAGE;

            // We don't want to send an e-mail to the assignee twice!
            //if ( $administrator->ID != $assignee_id ) {
                //$to = $administrator->user_email;
                //$to = ( $admin_email_address && is_email($admin_email_address) ) ? sanitize_email($admin_email_address) : '2sciencegr@gmail.com';

                // Send email to the administrator.
                wp_mail( $administrator->user_email, $subject, $message, $headers );
            //}
        }
    }

}

//================================================================================
// NOTIFICATION UPDATES.
//================================================================================

/**
 * We'll send email to the applicant, 
 * whenever an Event's status has been altered to approved.
 */
function send_emails_on_event_approval($post_id) {

    global $EMAIL_SIGNATURE_MESSAGE;

    $request_title = get_the_title($post_id);
    $applicant_name = get_field('event_applicant_name', $post_id);
    $applicant_email = sanitize_email( get_field('event_applicant_email', $post_id) );

    // $request_statuses = get_the_terms( $post_id, 'event-status' );
    // $request_status = null;
    // foreach ( $request_statuses as $status ) {
    //     $request_status = $status->name;
    // }

    $headers = array(
        'MIME-Version: 1.0',
        'Content-Type: text/html; charset=UTF-8'
    );

    $to = $applicant_email;
    $subject = __('Your Event has been approved', 'erua');

    $message = __('Dear', 'erua') . ' ' . $applicant_name . ',';
    $message .= '<br /><br />';
    $message = __('Your Event has been reviewed and published. You can view your Event here:', 'erua');
    $message .= '<br />';
    $message .= '<a href="' . get_post_permalink($post_id) . '">' . get_post_permalink($post_id) . '</a>';
    $message .= '<br /><br />';
    $message .= $EMAIL_SIGNATURE_MESSAGE;

    // Send email to the applicant.
    wp_mail( $to, $subject, $message, $headers );

}
