<?php
/**
 * Create an ACF form, and use hooks to handle 
 * the creation of a new custom post.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// FORM SHORTCODE DEFINITION
//================================================================================

/**
 * This function contains all the code needed 
 * to render the ACF form for submitting news, 
 * in the form of a WordPress shortcode.
 */
function news_form_shortcode( $atts ) {

    extract( shortcode_atts( array(), $atts ) );
    $output = '';

    ob_start();

    // Show the form only to logged-in users
    //if (is_user_logged_in()) {

        // https://www.advancedcustomfields.com/resources/acf_register_form/
        $settings = array(

            /* (string) Unique identifier for the form. Defaults to 'acf-form' */
            'id' => 'news-form',

            /* (int|string) The post ID to load data from and save data to. Defaults to the current post ID.
            Can also be set to 'new_post' to create a new post on submit */
            //'post_id'		=> "user_" . $current_user->ID,
            'post_id'		=> 'new_post',

            /* (array) An array of post data used to create a post. See wp_insert_post for available parameters.
	        The above 'post_id' setting must contain a value of 'new_post' */
            // 'new_post'	=> array(
            //     'post_type'		=> 'request',
            //     'post_status'	=> 'publish'
            // ),

            /* (array) An array of field group IDs/keys to override the fields displayed in this form */
            //'field_groups' => array('group_5a16ce3c67cb6', 'group_59f6eb9e7c014'),
            'field_groups' => array('group_63562f5f81bf0'),

            /* (array) An array of field IDs/keys to override the fields displayed in this form */
	        //'fields' => false,

            /* (boolean) Whether or not to show the post title text field. Defaults to false */
            'post_title' => false,

            /* (boolean) Whether or not to show the post content editor field. Defaults to false */
            'post_content' => false,

            /* (boolean) Whether or not to create a form element. Useful when a adding to an existing form. Defaults to true */
            'form' => true,
                                                
            /* (string) The URL to be redirected to after the form is submit. Defaults to the current URL with a GET parameter '?updated=true'.
            A special placeholder '%post_url%' will be converted to post's permalink (handy if creating a new post)
            A special placeholder '%post_id%' will be converted to post's ID (handy if creating a new post) */
            //'return' => '?updated=true#library-form-heading',
            'return'	=> site_url('news-submitted'), // Redirect to a thank you page
            //'return' => add_query_arg( 'updated', 'true', get_permalink() )

            /* (string) Extra HTML to add before the fields */
            //'html_before_fields' => '',

            /* (string) Extra HTML to add after the fields */
			'html_after_fields'  => '',
            //'html_after_fields'  => '<input type="hidden" id="event-categories-input" name="event-categories" value="' . implode(",", $event_categories) . '" />',

            /* (string) The text displayed on the submit button */
            'submit_value' => __('Submit', 'erua'),

            /* (string) A message displayed above the form after being redirected. Can also be set to false for no message */
            'updated_message' => __('Your news have been submitted!', 'erua'),

            /* (string) Determines where field labels are places in relation to fields. Defaults to 'top'.
            Choices of 'top' (Above fields) or 'left' (Beside fields) */
            'label_placement' => 'top',

            /* (string) Determines where field instructions are places in relation to fields. Defaults to 'label'.
            Choices of 'label' (Below labels) or 'field' (Below fields) */
            'instruction_placement' => 'label',

            /* (string) Determines element used to wrap a field. Defaults to 'div'
            Choices of 'div', 'tr', 'td', 'ul', 'ol', 'dl' */
            'field_el' => 'div',

            /* (string) Whether to use the WP uploader or a basic input for image and file fields. Defaults to 'wp'
            Choices of 'wp' or 'basic'. Added in v5.2.4 */
            'uploader' => 'wp'

            /* (boolean) Whether to include a hidden input field to capture non human form submission. Defaults to true. Added in v5.3.4 */
            //'honeypot' => true,

            /* (string) HTML used to render the updated message. Added in v5.5.10 */
            //'html_updated_message'	=> '<div id="message" class="updated"><p>%s</p></div>',

            /* (string) HTML used to render the submit button. Added in v5.5.10 */
            //'html_submit_button'	=> '<input type="submit" class="acf-button button button-primary button-large" value="%s" />',

            /* (string) HTML used to render the submit button loading spinner. Added in v5.5.10 */
            //'html_submit_spinner'	=> '<span class="acf-spinner"></span>',

            /* (boolean) Whether or not to sanitize all $_POST data with the wp_kses_post() function. Defaults to true. Added in v5.6.5 */
            //'kses'	=> true
        );

        acf_form($settings);
    //}

    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}
add_shortcode('news-form', 'news_form_shortcode');

//================================================================================
// FORM PROCESSING
//================================================================================

/**
 * Using a hook to act before an ACF form is saved,
 * we will cancel saving if conditions for a new post are not met, 
 * and if they are, we'll then get the POST data 
 * and insert it into the new post.
 */
function news_acf_form_pre_save_post( $post_id ) {

    // Stop function and bail early if not a new post
    if ( $post_id !== 'new_post' ) {
        return $post_id;
    }

    // echo '<pre>';
    // var_dump($_POST);
    // echo '</pre>';
    // die();

    if ( isset($_POST['acf']['field_63562f5f86447']) && $_POST['acf']['field_63562f5f86447'] === 'news' ) {

        // if ( !is_user_logged_in() ) {
        //     return $post_id;
        // }

        // echo '<pre>';
        // var_dump($_POST);
        // echo '</pre>';
        // die();

        // global $wp_query;
        // echo '<pre>';
        // var_dump($wp_query);
        // echo '</pre>';
        // die();

        //global $wp_roles;
        //$roles = $wp_roles->get_names();
        // Below code will print the list of all roles.
        //print_r($roles);

        // if (isset($_POST["preview-mode"])) {
        // 	get_template_part( '/template-parts/profile', 'preview' );
        // 	// Prevent the form from saving
        // 	die();
        // }
        // else {
        // 	// Save the post
        // 	do_action('acf/save_post' , $post_id);
        // }

        // Get the POST data
        if ( 
            isset($_POST['acf']['field_63562f5f860b4']) && 
            isset($_POST['acf']['field_63562f5f860fb'])
        ) {
            $post_title = wp_strip_all_tags( trim( $_POST['acf']['field_63562f5f860b4'] ) );
            $post_text = trim( $_POST['acf']['field_63562f5f860fb'] );
        }
        // If any crucial POST data is missing then abort
        else {
            return $post_id;
        }

        // If the user is a guest and has not set his name or e-mail, then abort.
        if ( !is_user_logged_in() && (!isset($_POST['acf']['field_63562f5f85fde']) || !isset($_POST['acf']['field_63562f5f86028'])) ) {
            return $post_id;
        }

        // echo '<pre>';
        // var_dump($_POST);
        // echo '</pre>';
        // die();

        // https://codex.wordpress.org/wp_get_current_user
        $current_user = wp_get_current_user();

        //$title = $questioner_name . ' (' . $questioner_email . ')';

        // Get "Open" status (custom taxonomies/categories)
        // $status_term = get_term_by('id', 95, 'post-status');
        // $status_slug = $status_term->slug;
        // $status = (int) $status_term->term_id;

        /**
         * Create a new post
         * https://developer.wordpress.org/reference/functions/wp_insert_post/#parameters
         * https://wordpress.stackexchange.com/questions/78543/wp-insert-post-or-wp-set-post-terms-do-not-save-taxonomy-but-wp-set-post-terms
         * https://wordpress.org/support/topic/polylangcount-posts-using-get_term_by/
         */
        $post = array(
            'post_status'	=> 'draft',
            'post_type'		=> 'post',
            'post_title'	=> $post_title,
            'post_author'	=> $current_user->ID,
            //'comment_status' => 'closed',
            'post_content'  => nl2br($post_text),
            // for core categories taxonomy only
            //'post_category' => array($category),
            // for custom taxonomies
            // 'tax_input'     => [
            //     'post-status' => [ intval( $status ) ],
            // ],
        );

        // Insert the post
        $post_id = wp_insert_post( $post );

        // Make it Private (private posts don't appear in the taxonomy term count!)
        //wp_update_post( array( 'ID' => $post_id, 'post_status' => 'private' ));

        /* var_dump($status_term);
        echo '<br><br>' . $status;
        echo '<span>' . $status_term->name . ' / '. $status_term->count . '</span>';
        die(); */

        /**
         * Since non logged-in users cannot use tax_input, 
         * we are setting the status and taxonomies AFTER the post's creation.
         */
        // if ( !is_user_logged_in() ) {
        //     $term_taxonomy_ids = wp_set_object_terms( $post_id, [ intval( $status ) ], 'post-status' );
        // }

        // Set its default status to "Open"
        //$term_taxonomy_ids = wp_set_object_terms( $post_id, array( intval( $status ) ), 'post-status' );
        //wp_set_post_terms( $post_id, array( (int) $status ), 'post-status' );
        //$terms_updated = wp_update_term_count_now( $status_term->term_taxonomy_id, 'post-status');

        /* var_dump($terms_updated);
        die(); */

        /* if ( is_wp_error( $term_taxonomy_ids ) ) {
            // There was an error somewhere and the terms couldn't be set.
            die();
        } else {
            // Success! These categories were added to the post.
        } */

        /**
         * Insert date created
         * https://developer.wordpress.org/reference/functions/get_post_time/
         */
        update_field( 'field_659396c14038b', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert date updated
         */
        update_field( 'field_659396c34038c', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert author/applicant
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_659396c84038d', $current_user->display_name, $post_id );
            update_field( 'field_659396cf4038f', $current_user->ID, $post_id );
        }
        else if ( isset($_POST['acf']['field_63562f5f85fde']) ) {
            update_field( 'field_659396c84038d', $_POST['acf']['field_63562f5f85fde'], $post_id );
        }

        /**
         * Insert author/applicant's e-mail
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_659396cc4038e', $current_user->user_email, $post_id );
        }
        else if ( isset($_POST['acf']['field_63562f5f86028']) ) {
            update_field( 'field_659396cc4038e', $_POST['acf']['field_63562f5f86028'], $post_id );
        }

        /**
         * Insert Applicant's Profile URL
         */
        if ( is_user_logged_in() && function_exists('bp_is_active') ) {
            update_field( 'field_659396d240390', bbp_get_user_profile_url( (int) $current_user->ID ), $post_id );
        }

        /**
         * Insert Tags
         * https://developer.wordpress.org/reference/functions/wp_set_post_tags/
         * https://stackoverflow.com/questions/10434686/wordpress-wp-insert-post-not-inserting-tags/16738025
         */
        if ( isset($_POST['acf']['field_6356373060279']) ) {
            wp_set_post_tags( $post_id, $_POST['acf']['field_6356373060279'] );
        }

        // Insert News Photo
        if ( isset($_POST['acf']['field_63562f5f863b5']) ) {
            update_field( 'field_634cadb1acc95', $_POST['acf']['field_63562f5f863b5'], $post_id );
        }

        /**
         * Create a unique_token for the post.
         * (1) Concatenate some data - the post's ID, the date and a random number for entropy.
         * (2) Hash the above data with SHA256, that way always producing a 64 characters string.
         * (3) Encode the produced hash into a base64 string and remove the padding, which will always be 
         *     a double "=" (i.e. two characters) since we are always encoding strings of a known, constant length.
         */
        $data_to_hash = $post_id . get_the_date('c', $post_id) . uniqid(rand(), TRUE);
        $unique_token = substr(base64_encode(hash('sha256', $data_to_hash, false)), 0, -2);
        update_field( 'field_659396d640391', $unique_token, $post_id );

        // Send e-mail notifications
        //send_emails_after_post_creation($post_id);
    }

    // Return the new ID
    return $post_id;

}
add_filter('acf/pre_save_post', 'news_acf_form_pre_save_post', 1, 1);

/**
 * Hooking into 'acf/save_post' with a high priority such as 20,
 * ensures that the $_POST data have already been saved,
 * and therefore we can get/access all custom fields of the post.
 * Alternatively we may use a priority lower than 10,
 * to manipulate the data before it gets saved.
 * 
 * https://www.advancedcustomfields.com/resources/acf-save_post/
 */
function news_acf_form_after_save_post( $post_id ) {

    if ( get_post_type($post_id) !== 'post' ) {
        return;
    }

    $date_created = get_field('field_659396c14038b', $post_id);
    $date_updated = get_field('field_659396c34038c', $post_id);

    /**
     * If these two dates match, then the document has never been saved/updated before
     * (because we refresh the $date_updated on each save using the 'save_post' hook),
     * and it has just been created.
     */
    if ( $date_created === $date_updated ) {
        // If a Media Attachment was uploaded to the post
        if ( get_field( 'field_6359327dbb43d', $post_id ) ) {

            global $DEFAULT_IMAGE;
            global $FILEBIRD_POSTS_FOLDER;
            $destination_filebird_folder = $FILEBIRD_POSTS_FOLDER; # 'Posts'
            $attachment = get_field( 'field_6359327dbb43d', $post_id );
            $attachment_id = $attachment['ID'];

            // Move the attachment to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }

        }
    }

    // https://developer.wordpress.org/reference/functions/get_post_status/#comment-4839
    $current_status = get_post_status($post_id);
    $previous_status = get_post_meta($post_id, 'news_status_tracking', true);

    // Don't send new email if the status didn't change!
    if ( $current_status === $previous_status ) {
        return;
    }

    if ( $current_status === 'publish' ) {
        //send_emails_on_post_approval($post_id);
    }
    update_field( 'field_64684293f7252', $current_status, $post_id );
}
add_action('acf/save_post', 'news_acf_form_after_save_post', 20);

//================================================================================
// FIELD HANDLING - WYSIWYG
//================================================================================

/**
 * Prepare the wysiwyg to have a character limit.
 * https://support.advancedcustomfields.com/forums/topic/set-max-length-for-editor/
 * https://www.advancedcustomfields.com/resources/acf-validate_value/
 * https://www.lettercount.com/
 */
function news_acf_form_validate_wysiwyg_field( $valid, $value, $field, $input ) {

    // echo '<pre>';
    // print_r($field);
    // echo '</pre>';
    // die();

    // bail early if value is already invalid
    if( !$valid ) {

        return $valid;

    }

    //$message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)) );
    $message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)), 'utf8' );
    //$message_length = strlen( htmlspecialchars_decode(strip_tags($value)));
    //$message_length = strlen( htmlspecialchars_decode(strip_tags(utf8_decode( $value ))) );

    if ( $message_length > 5000 ) {

        //$valid = __( "Your message is $message_length characters long. You can't enter more than 5000 characters.", 'erua' ) . ' ' . htmlspecialchars_decode(strip_tags($value));
        $valid = __( "Your message contains $message_length characters. The limit is at 5000 characters.", 'erua' );

    }
    
    // return
    return $valid;

}
add_filter('acf/validate_value/key=field_63562f5f860fb', 'news_acf_form_validate_wysiwyg_field', 10, 4);

//================================================================================
// FIELD HANDLING
//================================================================================

/**
 * Hide or show form fields depending on 
 * whether the user is logged-in or a guest.
 * https://www.advancedcustomfields.com/resources/acf-prepare_field/
 * https://www.advancedcustomfields.com/resources/get_field_object/
 */
function news_acf_form_prepare_guest_field( $field ) {

	// if( $field['value'] ) {
	// 	$field['disabled'] = true;	
    // }
    // $field['value'] = 'hmm';

    // We only want to show the field to guests, and hide it from logged-in users!
    if ( is_user_logged_in() ) {
        return false;
    }
    else {
        return $field;
    }

}
add_filter('acf/prepare_field/key=field_63562f5f85fde', 'news_acf_form_prepare_guest_field'); // Applicant's Name
add_filter('acf/prepare_field/key=field_63562f5f86028', 'news_acf_form_prepare_guest_field'); // Applicant's E-mail

//================================================================================
// FIELD HANDLING - FORM IDENTIFIER
//================================================================================

/**
 * Detect any change in the default value of the form identifier.
 */
function news_acf_form_validate_identifier( $valid, $value, $field, $input ) {
    // bail early if value is already invalid
    if ( !$valid ) {
        return $valid;
    }

    if ( $value !== $field['default_value'] ) {
        $valid = __( 'Incorrect form action', 'erua' );
    }

    return $valid;
}
add_filter('acf/validate_value/key=field_63562f5f86447', 'news_acf_form_validate_identifier', 10, 4);
