<?php
/**
 * This file contains functions that restrict users from viewing and accessing 
 * media of other users, when they are uploading new content to the Media Library.
 * We're also moving all newly uploaded media to their designated virtual folders. 
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// MEDIA ACCESS PERMISSIONS
//================================================================================

/**
 * *** IMPORTANT FUNCTION ***
 * 
 * Only Show Current User’s Attachments
 *
 * https://developer.wordpress.org/reference/functions/wp_ajax_query_attachments/
 * https://www.aliciaramirez.com/2014/03/my-new-best-friend-ajax_query_attachments_args/
 * https://developer.wordpress.org/reference/hooks/ajax_query_attachments_args/#user-contributed-notes
 * https://wordpress.stackexchange.com/questions/402154/filter-images-from-media-library-by-guid-meta-field
 * https://wordpress.stackexchange.com/questions/269291/how-to-load-attachment-in-media-library-for-current-user
 * https://wordpress.stackexchange.com/questions/351940/how-do-i-detect-in-which-page-ajax-query-attachments-args-is-loaded
 * https://stackoverflow.com/questions/49256599/how-to-restrict-media-library-grid-view-to-only-display-files-from-categories-cu
 */
function erua_restrict_current_user_to_own_attachments( $query = array() ) {

    // Allow requests only from users with access
	if ( ! current_user_can( 'upload_files' ) ) {
		wp_send_json_error();
	}

    /**
     * Restrict Media Library access for media uploading,
     * to allow users to see only their own uploaded files.
     * 
     * Identify the field initiating the request, as "_acfuploader":
     * https://stackoverflow.com/questions/38654423/different-restrictions-on-media-library-modal
     * https://support.advancedcustomfields.com/forums/topic/getting-the-id-of-the-current-post-before-wp_handle_upload_prefilter/
     */
    if ( array_key_exists('_acfuploader', $_POST['query']) ) {
        //-------------------------------------------------------------------
        // MODULE #2 "ERUAHAUS" - PROJECTS
        //-------------------------------------------------------------------
        if ( $_POST['query']['_acfuploader'] == 'field_654bb542689ac' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp',
                'mp4' => 'video/mp4',
                'ogg' => 'video/ogg',
                'webm' => 'video/webm',
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER;
                // Find all attachments inside the designated FileBird folder for platforms
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_654bb5c3c3c84' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_PROJECTS_FEATURED_IMAGES_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_PROJECTS_FEATURED_IMAGES_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        //-------------------------------------------------------------------
        // MODULE #2 "ERUAHAUS" - CREATIVE BLOG
        //-------------------------------------------------------------------
        else if ( $_POST['query']['_acfuploader'] == 'field_65668d348d41c' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_CREATIVE_BLOG_FEATURED_IMAGES_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_CREATIVE_BLOG_FEATURED_IMAGES_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        //-------------------------------------------------------------------
        // MODULE #2 "ERUAHAUS" - SHOWROOM PRESENTATIONS
        //-------------------------------------------------------------------
        else if ( $_POST['query']['_acfuploader'] == 'field_655edcc3821d5' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_SHOWROOM_FEATURED_IMAGES_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_SHOWROOM_FEATURED_IMAGES_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_65652233630fe' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_SHOWROOM_GALLERY_IMAGES_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_SHOWROOM_GALLERY_IMAGES_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_6565225896582' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'mp4' => 'video/mp4',
                'ogg' => 'video/ogg',
                'webm' => 'video/webm'
            ];

            if ( $user_id ) {
                global $FILEBIRD_ERUAHAUS_SHOWROOM_VIDEOS_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_SHOWROOM_VIDEOS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_6593800a550e7' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_EVENTS_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_EVENTS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        //-------------------------------------------------------------------
        // MODULE #5 "NEWS & EVENTS"
        //-------------------------------------------------------------------
        else if ( $_POST['query']['_acfuploader'] == 'field_634ae4a85cff5' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_EVENTS_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_EVENTS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_65aae9554f7f1' || $_POST['query']['_acfuploader'] == 'field_65aaf8a8b8410' ) {

            $user_id = get_current_user_id();

            $post_mime_type = ['application/pdf', 'application/x-pdf', 'application/acrobat'];

            if ( $user_id ) {
                global $FILEBIRD_EVENTS_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_EVENTS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
        else if ( $_POST['query']['_acfuploader'] == 'field_63562f5f863b5' ) {

            $user_id = get_current_user_id();

            $post_mime_type = [
                'jpg|jpeg|jpe' => 'image/jpeg',
                'gif' => 'image/gif',
                'png' => 'image/png',
                'webp' => 'image/webp'
            ];

            if ( $user_id ) {
                global $FILEBIRD_POSTS_FOLDER;
                // Find all attachments inside the designated FileBird folder
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_POSTS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }

                // Query only attachments uploaded by the current user
                $query['author'] = $user_id;
                //$query['post_mime_type'] = 'image';
                // Filter/query only attachments of specific mime types
                $query['post_mime_type'] = $post_mime_type;
            }
        }
    }


    //-------------------------------------------------------------------
    // WYSIWYG EDITORS: "ADD MEDIA"
    //-------------------------------------------------------------------

    /**
     * Restrict Media Library Access.
     * No manipulation for admins. After all they have access to all images.
     * 
     * Good guide:
     * https://www.vanbodevelops.com/tutorials/wordpress-media-uploader-restrict-user-to-accessing-only-files-they-uploaded
     * 
     * Other resources:
     * https://wp-qa.com/how-to-hide-add-media-from-frontend-users
     * https://toolset.com/forums/topic/restrict-media-library-access/
     * https://wordpress.stackexchange.com/questions/55745/is-admin-returns-true-when-using-admin-ajax-php-from-front-end-script
     * https://support.advancedcustomfields.com/forums/topic/acf_form-media-uploader-you-dont-have-permission-to-attach-files-to-this-post/
     */
     if ( !$_POST['query']['_acfuploader'] && $_POST['action'] == 'query-attachments' && !current_user_can( 'administrator' ) ) {

        $user_id = get_current_user_id();

        // Filter to display only images or specific mime types
        // $query['post_mime_type'] = array(
        //     'image/gif',
        //     'image/jpeg',
        //     'image/png',
        //     'image/bmp',
        //     'image/tiff',
        //     'image/x-icon'
        // );

        //if ( strpos( $_SERVER[ 'REQUEST_URI' ], '/wp-admin/upload.php' ) !== false )
        //if ( strpos( $_SERVER[ 'REQUEST_URI' ], '/wp-admin/user-edit.php' ) !== false )
        //if ( strpos( $_SERVER[ 'REQUEST_URI' ], '/wp-admin/profile.php' ) !== false )

        if ( $user_id ) {

            // if the request came from this URL
            if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/news/" ) !== false ) {

                global $FILEBIRD_BLOG_MEDIA_FOLDER;

                // Find all attachments inside the designated FileBird folder for media
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_BLOG_MEDIA_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }
            }
            else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-your-project/" ) !== false ) {

                global $FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER;

                // Find all attachments inside the designated FileBird folder for media
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }
            }
            else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/share-your-presentation/" ) !== false ) {

                global $FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER;

                // Find all attachments inside the designated FileBird folder for media
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }
            }
            else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/eruahaus-posts/" ) !== false ) {

                global $FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER;

                // Find all attachments inside the designated FileBird folder for media
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }
            }
            else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-showroom-event/" ) !== false || strpos( $_SERVER[ 'HTTP_REFERER' ], "/add-an-event/" ) !== false ) {

                global $FILEBIRD_EVENTS_FOLDER;

                // Find all attachments inside the designated FileBird folder for media
                $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_EVENTS_FOLDER);

                // Query only for these attachments
                if ( $attachment_ids ) {
                    $query['post__in'] = $attachment_ids;
                }
                else {
                    $query['post__in'] = array(-1); # passing invalid IDs
                }
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }

    }
    // Rules for Administrators only
    else if ( !$_POST['query']['_acfuploader'] && $_POST['action'] == 'query-attachments' && current_user_can( 'administrator' ) ) {

        $user_id = get_current_user_id();

        /**
         * Somehow the option 'category__not_in' was set to exclude number 102,
         * which was related to BuddyPress, and as a result all BuddyPress 
         * did not show in the Media Library.
         */
        if ( array_key_exists('category__not_in', $query) && in_array('102', $query['category__not_in']) ) {
            $query['category__not_in'] = [];
        }

        // if the request came from this URL
        if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/news/" ) !== false && $user_id ) {

            global $FILEBIRD_BLOG_MEDIA_FOLDER;

            // Find all attachments inside the designated FileBird folder for media
            $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_BLOG_MEDIA_FOLDER);

            // Query only for these attachments
            if ( $attachment_ids ) {
                $query['post__in'] = $attachment_ids;
            }
            else {
                $query['post__in'] = array(-1); # passing invalid IDs
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }
        else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-your-project/" ) !== false && $user_id ) {

            global $FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER;

            // Find all attachments inside the designated FileBird folder for media
            $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER);

            // Query only for these attachments
            if ( $attachment_ids ) {
                $query['post__in'] = $attachment_ids;
            }
            else {
                $query['post__in'] = array(-1); # passing invalid IDs
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }
        else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/share-your-presentation/" ) !== false && $user_id ) {

            global $FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER;

            // Find all attachments inside the designated FileBird folder for media
            $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER);

            // Query only for these attachments
            if ( $attachment_ids ) {
                $query['post__in'] = $attachment_ids;
            }
            else {
                $query['post__in'] = array(-1); # passing invalid IDs
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }
        else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/eruahaus-posts/" ) !== false && $user_id ) {

            global $FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER;

            // Find all attachments inside the designated FileBird folder for media
            $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER);

            // Query only for these attachments
            if ( $attachment_ids ) {
                $query['post__in'] = $attachment_ids;
            }
            else {
                $query['post__in'] = array(-1); # passing invalid IDs
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }
        else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-showroom-event/" ) !== false || strpos( $_SERVER[ 'HTTP_REFERER' ], "/add-an-event/" ) !== false ) {

            global $FILEBIRD_EVENTS_FOLDER;

            // Find all attachments inside the designated FileBird folder for media
            $attachment_ids = filebird_folder_get_attachment_ids($FILEBIRD_EVENTS_FOLDER);

            // Query only for these attachments
            if ( $attachment_ids ) {
                $query['post__in'] = $attachment_ids;
            }
            else {
                $query['post__in'] = array(-1); # passing invalid IDs
            }

            // Query only attachments uploaded by the current user
            $query['author'] = $user_id;
        }
    }

    return $query;
}
// Filter wp uploader shown attachments using ajax_query_attachments_args
add_filter( 'ajax_query_attachments_args', 'erua_restrict_current_user_to_own_attachments', 10, 1 );

/**
 * Modify the query for Media Library "attachment" at the back-end.
 */
function erua_media_library_attachment_query( $query ) {
    if ( is_admin() && get_query_var( 'post_type' ) == 'attachment' && $query->is_main_query() && current_user_can('administrator') ) {
        // echo '<pre>';
        // var_dump($query);
        // echo '</pre>';

        /**
         * Somehow the option 'category__not_in' was set to exclude number 102,
         * which was related to BuddyPress, and as a result all BuddyPress 
         * did not show in the Media Library.
         */
        if ( ! empty(get_query_var( 'category__not_in' )) ) $query->set( 'category__not_in', [] );
    }
}
add_action( 'pre_get_posts', 'erua_media_library_attachment_query' );

//================================================================================
// MOVING (WYSIWYG EDITOR) MEDIA TO DESIGNATED VIRTUAL FOLDERS
//================================================================================

/**
 * Move media files uploaded from the WYSIWYG editors' "ADD MEDIA" buttons,
 * to a designated FileBird folder.
 *
 * https://developer.wordpress.org/reference/hooks/add_attachment/
 * https://wordpress.stackexchange.com/questions/141675/wordpress-upload-file-action-hook
 * https://stackoverflow.com/questions/17485176/check-if-we-are-in-new-media-uploader-or-media-add-new-wordpress
 * https://support.advancedcustomfields.com/forums/topic/wysiwyg-editor-hooks-for-add-media-button/
 * https://wordpress.stackexchange.com/questions/224633/which-hook-is-fired-when-inserting-media-into-a-post
 */
function erua_move_document_media_to_filebird_folder( $attachment_ID ) {

    // global $post; echo $post->id;
    // $post_id = $_GET['post'];
    // $post_id = $_POST['post'];
    // $post_id = $_REQUEST['post_id'];

    if ( ! current_user_can( 'upload_files' ) ) {
        return;
    }

    /**
     * Use the Title, Caption and Description, to output/diagnose the referer and other data.
     * 
     * https://wordpress.stackexchange.com/questions/121709/how-can-i-add-a-default-description-to-uploaded-files
     * https://stackoverflow.com/questions/43640228/what-kind-of-data-should-be-in-data-argument-in-the-wp-update-attachment-metada
     */
    $args = array( 
        'ID'           => $attachment_ID, 
        //'post_title' => 'My default title ...', 
        //'post_excerpt' => 'My default caption ...', 
        'post_content' => 'Uploaded from:' . PHP_EOL . parse_url($_SERVER[ 'HTTP_REFERER' ], PHP_URL_PATH), 
    );
    // Update attachment details that were uploaded at the front-end
    if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/wp-admin/" ) === false ) {
        wp_update_post( $args );
    }

    // if the request came from this URL
    if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/news/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_BLOG_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_BLOG_MEDIA_FOLDER; # 'Blog Media'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-your-project/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER; # 'ERUAHAUS PROJECT MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/eruahaus-posts/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_ERUAHAUS_CREATIVE_BLOG_MEDIA_FOLDER; # 'ERUAHAUS CREATIVE BLOG MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/share-your-presentation/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_ERUAHAUS_SHOWROOM_PRESENTATION_MEDIA_FOLDER; # 'ERUAHAUS SHOWROOM MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/create-showroom-event/" ) !== false || strpos( $_SERVER[ 'HTTP_REFERER' ], "/add-an-event/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_EVENTS_FOLDER;

        $destination_filebird_folder = $FILEBIRD_EVENTS_FOLDER; # 'EVENTS MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/members/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_BP_MEMBER_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_BP_MEMBER_MEDIA_FOLDER; # 'BP MEMBER MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }
    else if ( strpos( $_SERVER[ 'HTTP_REFERER' ], "/groups/" ) !== false ) {

        global $DEFAULT_IMAGE;
        global $FILEBIRD_BP_GROUP_MEDIA_FOLDER;

        $destination_filebird_folder = $FILEBIRD_BP_GROUP_MEDIA_FOLDER; # 'BP GROUP MEDIA'

        // Move the attachment to the appropriate FileBird folder.
        if ( $attachment_ID !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
            move_attachment_to_filebird_folder( $attachment_ID, $destination_filebird_folder );
        }
    }

}
add_action( 'add_attachment', 'erua_move_document_media_to_filebird_folder', 10, 1 );
