<?php
/**
 * Create an ACF form, and use hooks to handle 
 * the creation of a new custom post.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// FORM SHORTCODE DEFINITION
//================================================================================

/**
 * This function contains all the code needed 
 * to render the ACF form for submitting projects, 
 * in the form of a WordPress shortcode.
 */
function eruahaus_projects_form_shortcode( $atts ) {

    extract( shortcode_atts( array(), $atts ) );
    $output = '';

    $user = wp_get_current_user();
    $allowed_roles = array('administrator', 'eruaner');

    ob_start();

    // Show the form only to logged-in users
    if ( is_user_logged_in() && $user && array_intersect($allowed_roles, $user->roles) ) {

        // https://www.advancedcustomfields.com/resources/acf_register_form/
        $settings = array(

            /* (string) Unique identifier for the form. Defaults to 'acf-form' */
            'id' => 'eruahaus-projects-form',

            /* (int|string) The post ID to load data from and save data to. Defaults to the current post ID.
            Can also be set to 'new_post' to create a new post on submit */
            //'post_id'		=> "user_" . $current_user->ID,
            'post_id'		=> 'new_post',

            /* (array) An array of post data used to create a post. See wp_insert_post for available parameters.
	        The above 'post_id' setting must contain a value of 'new_post' */
            // 'new_post'	=> array(
            //     'post_type'		=> 'request',
            //     'post_status'	=> 'publish'
            // ),

            /* (array) An array of field group IDs/keys to override the fields displayed in this form */
            //'field_groups' => array('group_5a16ce3c67cb6', 'group_59f6eb9e7c014'),
            'field_groups' => array('group_654a6b74112a4'),

            /* (array) An array of field IDs/keys to override the fields displayed in this form */
	        //'fields' => false,

            /* (boolean) Whether or not to show the post title text field. Defaults to false */
            'post_title' => false,

            /* (boolean) Whether or not to show the post content editor field. Defaults to false */
            'post_content' => false,

            /* (boolean) Whether or not to create a form element. Useful when a adding to an existing form. Defaults to true */
            'form' => true,
                                                
            /* (string) The URL to be redirected to after the form is submit. Defaults to the current URL with a GET parameter '?updated=true'.
            A special placeholder '%post_url%' will be converted to post's permalink (handy if creating a new post)
            A special placeholder '%post_id%' will be converted to post's ID (handy if creating a new post) */
            //'return' => '?updated=true#library-form-heading',
            'return'	=> site_url('project-submitted'), // Redirect to a thank you page
            //'return' => add_query_arg( 'updated', 'true', get_permalink() )

            /* (string) Extra HTML to add before the fields */
            //'html_before_fields' => '',

            /* (string) Extra HTML to add after the fields */
			'html_after_fields'  => '',
            //'html_after_fields'  => '<input type="hidden" id="project-categories-input" name="project-categories" value="' . implode(",", $project_categories) . '" />',

            /* (string) The text displayed on the submit button */
            'submit_value' => __('Submit', 'erua'),

            /* (string) A message displayed above the form after being redirected. Can also be set to false for no message */
            'updated_message' => __('Your project has been submitted!', 'erua'),

            /* (string) Determines where field labels are places in relation to fields. Defaults to 'top'.
            Choices of 'top' (Above fields) or 'left' (Beside fields) */
            'label_placement' => 'top',

            /* (string) Determines where field instructions are places in relation to fields. Defaults to 'label'.
            Choices of 'label' (Below labels) or 'field' (Below fields) */
            'instruction_placement' => 'label',

            /* (string) Determines element used to wrap a field. Defaults to 'div'
            Choices of 'div', 'tr', 'td', 'ul', 'ol', 'dl' */
            'field_el' => 'div',

            /* (string) Whether to use the WP uploader or a basic input for image and file fields. Defaults to 'wp'
            Choices of 'wp' or 'basic'. Added in v5.2.4 */
            'uploader' => 'wp'

            /* (boolean) Whether to include a hidden input field to capture non human form submission. Defaults to true. Added in v5.3.4 */
            //'honeypot' => true,

            /* (string) HTML used to render the updated message. Added in v5.5.10 */
            //'html_updated_message'	=> '<div id="message" class="updated"><p>%s</p></div>',

            /* (string) HTML used to render the submit button. Added in v5.5.10 */
            //'html_submit_button'	=> '<input type="submit" class="acf-button button button-primary button-large" value="%s" />',

            /* (string) HTML used to render the submit button loading spinner. Added in v5.5.10 */
            //'html_submit_spinner'	=> '<span class="acf-spinner"></span>',

            /* (boolean) Whether or not to sanitize all $_POST data with the wp_kses_post() function. Defaults to true. Added in v5.6.5 */
            //'kses'	=> true
        );

        acf_form($settings);
    }
    else {
        $eruahaus_eruaner_membership_request_page_id = ( get_field('eruahaus_eruaner_membership_request_page', 'option') ) ?? null;
        $login_url = ($eruahaus_eruaner_membership_request_page_id ) ? get_permalink($eruahaus_eruaner_membership_request_page_id) : site_url() . '/login/'; # get_permalink( get_option('woocommerce_myaccount_page_id') );
        echo '<a href="' . $login_url . '" id="logreg">Login and become an ERUAner to submit a project</a>';
    }

    $output = ob_get_contents();
    ob_end_clean();

    return $output;
}
add_shortcode('eruahaus-projects-form', 'eruahaus_projects_form_shortcode');

//================================================================================
// FORM PROCESSING
//================================================================================

/**
 * Using a hook to act before an ACF form is saved,
 * we will cancel saving if conditions for a new post are not met, 
 * and if they are, we'll then get the POST data 
 * and insert it into the new post.
 */
function eruahaus_projects_acf_form_pre_save_post( $post_id ) {

	// Stop function and bail early if not a new post
	if ( $post_id !== 'new_post' ) {
		return $post_id;
    }

    if ( isset($_POST['acf']['field_654a6d0afca2d']) && $_POST['acf']['field_654a6d0afca2d'] === 'eruahaus-project' ) {

        // echo '<pre>';
        // var_dump('$_POST');
        // echo '</pre>';
        // die();

        if ( !is_user_logged_in() ) {
            return $post_id;
        }

        // global $wp_query;
        // echo '<pre>';
        // var_dump($wp_query);
        // echo '</pre>';
        // die();

        //global $wp_roles;
        //$roles = $wp_roles->get_names();
        // Below code will print the list of all roles.
        //print_r($roles);

        // if (isset($_POST["preview-mode"])) {
        // 	get_template_part( '/template-parts/profile', 'preview' );
        // 	// Prevent the form from saving
        // 	die();
        // }
        // else {
        // 	// Save the post
        // 	do_action('acf/save_post' , $post_id);
        // }

        // Get the POST data
        if ( 
            isset($_POST['acf']['field_654a6fc571a32']) && 
            isset($_POST['acf']['field_654bbd012dc61']) 
        ) {
            $project_title = wp_strip_all_tags( trim( $_POST['acf']['field_654a6fc571a32'] ) );
            $project_description = trim( $_POST['acf']['field_654bbd012dc61'] );
        }
        // If any crucial POST data is missing then abort
        else {
            return $post_id;
        }

        // If the user is a guest and has not set his name or e-mail, then abort.
        if ( !is_user_logged_in() && (!isset($_POST['acf']['field_654a6b7553978']) || !isset($_POST['acf']['field_654a6c81fca2b'])) ) {
            return $post_id;
        }

        // echo '<pre>';
        // var_dump($_POST);
        // echo '</pre>';
        // die();

        // https://codex.wordpress.org/wp_get_current_user
        $current_user = wp_get_current_user();

        //$title = $questioner_name . ' (' . $questioner_email . ')';

        // Get "Open" status (custom taxonomies/categories)
        // $status_term = get_term_by('id', 95, 'event-status');
        // $status_slug = $status_term->slug;
        // $status = (int) $status_term->term_id;

        /**
         * Create a new post
         * https://developer.wordpress.org/reference/functions/wp_insert_post/#parameters
         * https://wordpress.stackexchange.com/questions/78543/wp-insert-post-or-wp-set-post-terms-do-not-save-taxonomy-but-wp-set-post-terms
         * https://wordpress.org/support/topic/polylangcount-posts-using-get_term_by/
         */
        $post = array(
            'post_status'	=> 'draft',
            'post_type'		=> 'eruahaus-project',
            'post_title'	=> $project_title,
            'post_author'	=> $current_user->ID,
            //'comment_status' => 'closed',
            'post_content'  => nl2br($project_description),
            // for core categories taxonomy only
            //'post_category' => array($category),
            // for custom taxonomies
            // 'tax_input'     => [
            //     'project-status' => [ intval( $status ) ],
            // ],
        );

        // Insert the post
        $post_id = wp_insert_post( $post );

        // Make it Private (private posts don't appear in the taxonomy term count!)
        //wp_update_post( array( 'ID' => $post_id, 'post_status' => 'private' ));

        /* var_dump($status_term);
        echo '<br><br>' . $status;
        echo '<span>' . $status_term->name . ' / '. $status_term->count . '</span>';
        die(); */

        /**
         * Since non logged-in users cannot use tax_input, 
         * we are setting the status and taxonomies AFTER the post's creation.
         */
        // if ( !is_user_logged_in() ) {
        //     $term_taxonomy_ids = wp_set_object_terms( $post_id, [ intval( $status ) ], 'event-status' );
        // }

        // Set its default status to "Open"
        //$term_taxonomy_ids = wp_set_object_terms( $post_id, array( intval( $status ) ), 'event-status' );
        //wp_set_post_terms( $post_id, array( (int) $status ), 'event-status' );
        //$terms_updated = wp_update_term_count_now( $status_term->term_taxonomy_id, 'event-status');

        /* var_dump($terms_updated);
        die(); */

        /* if ( is_wp_error( $term_taxonomy_ids ) ) {
            // There was an error somewhere and the terms couldn't be set.
            die();
        } else {
            // Success! These categories were added to the post.
        } */

        /**
         * Insert date created
         * https://developer.wordpress.org/reference/functions/get_post_time/
         */
        update_field( 'field_6543bd37c96b1', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert date updated
         */
        update_field( 'field_6543bd3bc96b2', get_post_time('j F Y, H:i', false, $post_id, false ), $post_id );

        /**
         * Insert author/applicant
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_6543bd41c96b3', $current_user->display_name, $post_id );
            update_field( 'field_6543bd4fc96b5', $current_user->ID, $post_id );
        }
        else if ( isset($_POST['acf']['field_654a6b7553978']) ) {
            update_field( 'field_6543bd41c96b3', $_POST['acf']['field_654a6b7553978'], $post_id );
        }

        /**
         * Insert author/applicant's e-mail
         */
        if ( is_user_logged_in() ) {
            update_field( 'field_6543bd4ac96b4', $current_user->user_email, $post_id );
        }
        else if ( isset($_POST['acf']['field_654a6c81fca2b']) ) {
            update_field( 'field_6543bd4ac96b4', $_POST['acf']['field_654a6c81fca2b'], $post_id );
        }

        /**
         * Insert Applicant's Profile URL
         */
        if ( is_user_logged_in() && function_exists('bp_is_active') ) {
            update_field( 'field_655b8e5149d2c', bbp_get_user_profile_url( (int) $current_user->ID ), $post_id );
        }

        /**
         * Insert Fields of science
         */
        // if ( isset($_POST['acf']['field_655bb4a085660']) ) {
        //     wp_set_object_terms( $post_id, [ intval( $_POST['acf']['field_655bb4a085660'] ) ], 'eruahaus-science-field' );
        // }

        /**
         * Insert project keywords
         */
        // if ( isset($_POST['acf']['field_655bb89f6b3d9']) ) {
        //     wp_set_object_terms( $post_id, [ intval( $_POST['acf']['field_655bb89f6b3d9'] ) ], 'eruahaus-project-keyword' );
        // }

        /**
         * Create a unique_token for the post.
         * (1) Concatenate some data - the post's ID, the date and a random number for entropy.
         * (2) Hash the above data with SHA256, that way always producing a 64 characters string.
         * (3) Encode the produced hash into a base64 string and remove the padding, which will always be 
         *     a double "=" (i.e. two characters) since we are always encoding strings of a known, constant length.
         */
        $data_to_hash = $post_id . get_the_date('c', $post_id) . uniqid(rand(), TRUE);
        $unique_token = substr(base64_encode(hash('sha256', $data_to_hash, false)), 0, -2);
        update_field( 'field_6543bd56c96b7', $unique_token, $post_id );

        //wp_update_post( ['ID' => $post_id] );

        // Send e-mail notifications
        //send_emails_after_project_creation($post_id);
    }

    // Return the new ID
    return $post_id;

}
add_filter('acf/pre_save_post', 'eruahaus_projects_acf_form_pre_save_post', 1, 1);

/**
 * Hooking into 'acf/save_post' with a high priority such as 20,
 * ensures that the $_POST data have already been saved,
 * and therefore we can get/access all custom fields of the post.
 * Alternatively we may use a priority lower than 10,
 * to manipulate the data before it gets saved.
 * 
 * https://www.advancedcustomfields.com/resources/acf-save_post/
 */
function eruahaus_projects_acf_form_after_save_post( $post_id ) {

    if ( get_post_type($post_id) !== 'eruahaus-project' ) {
        return;
    }

    $date_created = get_field('field_6543bd37c96b1', $post_id);
    $date_updated = get_field('field_6543bd3bc96b2', $post_id);

    /**
     * If these two dates match, then the project has never been saved/updated before
     * (because we refresh the $date_updated on each save using the 'save_post' hook),
     * and it has just been created.
     */
    if ( $date_created === $date_updated ) {

        global $DEFAULT_IMAGE;

        $project_slider_media = get_field( 'field_654282d721164', $post_id );
        $project_featured_image = get_field( 'field_654282f61df95', $post_id );

        //global $FILEBIRD_ERUAHAUS_PROJECTS_FOLDER;
        global $FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER;
        global $FILEBIRD_ERUAHAUS_PROJECTS_FEATURED_IMAGES_FOLDER;
        //global $FILEBIRD_ERUAHAUS_PROJECTS_BODY_MEDIA_FOLDER;

        // If slider media were uploaded to the post
        if ( $project_slider_media && filebird_folder_exists( $FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER ) ) {

            foreach ( $project_slider_media as $media ) {
                if ( $media['eruahaus_project_slider_media_file'] ) {

                    $attachment_id = $media['eruahaus_project_slider_media_file']['ID'];

                    // Move the attachment to the appropriate FileBird folder.
                    if ( $attachment_id !== 0 && $attachment_id !== $DEFAULT_IMAGE ) {
                        move_attachment_to_filebird_folder( $attachment_id, $FILEBIRD_ERUAHAUS_PROJECTS_SLIDER_MEDIA_FOLDER );
                    }
                }
            }
        }

        // If a featured image was uploaded to the post
        if ( $project_featured_image ) {

            $destination_filebird_folder = $FILEBIRD_ERUAHAUS_PROJECTS_FEATURED_IMAGES_FOLDER;
            $attachment_id = $project_featured_image['ID'];

            // Move the attachment to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && $attachment_id !== $DEFAULT_IMAGE && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }

        }

    }

    $current_status = get_post_status($post_id);
    $previous_status = get_post_meta($post_id, 'eruahaus_project_status_tracking', true);

    // Abort if the project has been published before!
    if ( $previous_status === 'publish' ) {
        return;
    }

    if ( $current_status === 'publish' ) {
        //send_emails_on_project_approval($post_id);

        /**
         * Create BP Group
         * https://tannermoushey.com/2014/08/create-groups-buddypress/
         * https://buddypress.org/support/topic/resolved-programmatically-creating-a-group/
         * https://www.green-box.co.uk/buddypress-create-group-programmatically-php-add-users/
         */
        if ( function_exists('groups_create_group') ) {

            $group_name = get_field('field_655bfefa672b0', $post_id) ?? 'Title';
            $group_desc = get_field('field_655bfeff672b1', $post_id) ?? 'Description';
            $user_id = get_field('eruahaus_project_registered_user_id', $post_id);

            if ( !  $user_id ) {
                return;
            }

            $args = array(
                //'group_id'     => 0,
                'creator_id'   => (int) $user_id,
                'name'         => $group_name,
                'description'  => $group_desc,
                //'slug'         => '',
                'status'       => 'public', # public, private, hidden
                'enable_forum' => 0,
                'date_created' => bp_core_current_time()
            );
            $group_id = groups_create_group($args);

            if ( $group_id ) {
                update_field( 'field_655bfaa72dc4a', $group_id, $post_id );
                $group_obj = groups_get_group( (int) $group_id );
                $group_url = bp_get_group_permalink( $group_obj );
                update_field( 'field_655c374abc657', $group_url, $post_id );
            }

            /**
             * Group Name & Description initial values are no longer needed to be stored,
             * so we will delete the values of these fields.
             */
            delete_field('field_655bfefa672b0', $post_id);
            delete_field('field_655bfeff672b1', $post_id);
        }
    }
    update_field( 'field_6543bd53c96b6', $current_status, $post_id );
}
add_action('acf/save_post', 'eruahaus_projects_acf_form_after_save_post', 20);

//================================================================================
// FIELD HANDLING - WYSIWYG
//================================================================================

/**
 * Prepare the wysiwyg to have a character limit.
 * https://support.advancedcustomfields.com/forums/topic/set-max-length-for-editor/
 * https://www.advancedcustomfields.com/resources/acf-validate_value/
 * https://www.lettercount.com/
 */
function eruahaus_projects_acf_form_validate_wysiwyg_field( $valid, $value, $field, $input ) {

    // echo '<pre>';
    // print_r($field);
    // echo '</pre>';
    // die();

    // bail early if value is already invalid
    if( !$valid ) {

        return $valid;

    }

    //$message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)) );
    $message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)), 'utf8' );
    //$message_length = strlen( htmlspecialchars_decode(strip_tags($value)));
    //$message_length = strlen( htmlspecialchars_decode(strip_tags(utf8_decode( $value ))) );

    if ( $message_length > 10000 ) {

        //$valid = __( "Your message is $message_length characters long. You can't enter more than 5000 characters.", 'erua' ) . ' ' . htmlspecialchars_decode(strip_tags($value));
        $valid = __( "Your message contains $message_length characters. The limit is at 10000 characters.", 'erua' );

    }

    // return
    return $valid;

}
add_filter('acf/validate_value/key=field_654bbd012dc61', 'eruahaus_projects_acf_form_validate_wysiwyg_field', 10, 4);
add_filter('acf/validate_value/key=field_654bb86d1e12e', 'eruahaus_projects_acf_form_validate_wysiwyg_field', 10, 4);

function eruahaus_projects_acf_form_validate_wysiwyg_field_v2( $valid, $value, $field, $input ) {
    if( !$valid ) {
        return $valid;
    }

    $message_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)), 'utf8' );

    if ( $message_length > 5000 ) {
        $valid = __( "Your message contains $message_length characters. The limit is at 5000 characters.", 'erua' );
    }

    return $valid;
}
add_filter('acf/validate_value/key=field_654bb87f1e132', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_65de4b33b2a67', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_65de50f06b3ba', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_65de5cfcbdc96', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_65de56b84c7c6', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_65de5a1006e1d', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_654bb8841e133', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_659a50c1ea2a4', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);
add_filter('acf/validate_value/key=field_6593c876cde10', 'eruahaus_projects_acf_form_validate_wysiwyg_field_v2', 10, 4);

//================================================================================
// FIELD HANDLING
//================================================================================

/**
 * Make sure that the Start Date is earlier than the Project's End Date.
 *
 * https://support.advancedcustomfields.com/forums/topic/validation-of-a-field-based-on-the-value-of-another-field/
 */
function eruahaus_projects_acf_form_validate_date_end_field( $valid, $value, $field, $input ) {

    // bail early if value is already invalid
    if( !$valid || !isset($_POST['acf']['field_654bb8651e12c']) ) {

        return $valid;

    }

    $project_date = date_create($_POST['acf']['field_654bb8651e12c']);
    $project_date_end = date_create($value);

    if ( $project_date === false || $project_date_end === false ) return $valid;

    // https://stackoverflow.com/a/29099815
    $diff_obj = date_diff( $project_date, $project_date_end );
    $diff = (int) $diff_obj->format("%R%a");

    if ( $diff < 0 ) {
        $valid = __( "Your Project's end date shouldn't be earlier than the start date.", 'erua' );
    }

    // return
    return $valid;
}
add_filter('acf/validate_value/key=field_654bb86a1e12d', 'eruahaus_projects_acf_form_validate_date_end_field', 10, 4);

/**
 * Make sure that the Group Name is long enough.
 */
function eruahaus_projects_acf_form_validate_group_name_field( $valid, $value, $field, $input ) {

    // echo '<pre>';
    // print_r($field);
    // echo '</pre>';
    // die();

    // bail early if value is already invalid
    if( !$valid ) {

        return $valid;

    }

    //$name_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)) );
    $name_length = mb_strlen( htmlspecialchars_decode(strip_tags($value)), 'utf8' );
    //$name_length = strlen( htmlspecialchars_decode(strip_tags($value)));
    //$name_length = strlen( htmlspecialchars_decode(strip_tags(utf8_decode( $value ))) );

    if ( $name_length < 3 ) {

        $valid = __( "The name should be at least 3 characters long.", 'erua' );

    }
    else if ( $name_length > 100 ) {
        $valid = __( "The name contains $name_length characters. The limit is at 100 characters.", 'erua' );
    }

    // return
    return $valid;

}
add_filter('acf/validate_value/key=field_655bfbaf68165', 'eruahaus_projects_acf_form_validate_group_name_field', 10, 4);

/**
 * Hide or show form fields depending on 
 * whether the user is logged-in or a guest.
 * https://www.advancedcustomfields.com/resources/acf-prepare_field/
 * https://www.advancedcustomfields.com/resources/get_field_object/
 */
function eruahaus_projects_acf_form_prepare_guest_field( $field ) {

	// if( $field['value'] ) {
	// 	$field['disabled'] = true;	
    // }
    // $field['value'] = 'hmm';

    // We only want to show the field to guests, and hide it from logged-in users!
    if ( is_user_logged_in() ) {
        return false;
    }
    else {
        return $field;
    }

}
add_filter('acf/prepare_field/key=field_654a6b7553978', 'eruahaus_projects_acf_form_prepare_guest_field'); // Applicant's Name
add_filter('acf/prepare_field/key=field_654a6c81fca2b', 'eruahaus_projects_acf_form_prepare_guest_field'); // Applicant's E-mail

//================================================================================
// FIELD HANDLING - FORM IDENTIFIER
//================================================================================

/**
 * Detect any change in the default value of the form identifier.
 */
function eruahaus_projects_acf_form_validate_identifier( $valid, $value, $field, $input ) {
    // bail early if value is already invalid
    if ( !$valid ) {
        return $valid;
    }

    if ( $value !== $field['default_value'] ) {
        $valid = __( 'Incorrect form action', 'erua' );
    }

    return $valid;
}
add_filter('acf/validate_value/key=field_654a6d0afca2d', 'eruahaus_projects_acf_form_validate_identifier', 10, 4);
