<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

//flush_rewrite_rules();

//================================================================================
// DEBUG AJAX
//================================================================================

/**
 * This function helps us to figure out what’s going on in a ajax call,
 * because we can’t use the standard php debugging techniques like echo and print_r().
 * What it does is it writes stuff to a file on the server so we can see what we want to see
 * without interrupting the AJAX call and without writing miles of code to alter WP code the get an output.
 * 
 * So, we may use it inside a specific ajax add_filter call and
 * see if a value is set and then use that to determine how to modify the query.
 * 
 * https://support.advancedcustomfields.com/forums/topic/filter-gallery-items/
 */
function write_to_file($value) {
    // this function for testing & debugging only
    // do not leave this function working on your site
    $file = dirname(__FILE__).'/__data.txt';
    $handle = fopen($file, 'a');
    ob_start();
    if (is_array($value) || is_object($value)) {
        print_r($value);
    } elseif (is_bool($value)) {
        var_dump($value);
    } else {
        echo $value;
    }
    echo "\r\n\r\n";
    fwrite($handle, ob_get_clean());
    fclose($handle);
}

function write_attachment_query_to_file($query=array()) {
    write_to_file($_POST);
    write_to_file($query);
    return $query;
}
add_filter( 'ajax_query_attachments_args', 'write_attachment_query_to_file', 10, 1 );
