<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// CONTACT7
//================================================================================

/**
 * Load Contact7 scripts and styles, only on Contact page.
 * https://wordpress.org/support/topic/recaptcha-badge-on-all-pages-not-just-pages-with-contact-forms/
 */
function erua_conditionally_load_contact7_js_css() {
    if ( !is_admin() && !is_page( 90 ) && !is_author() ) { # Only load CSS and JS on needed Pages
		wp_dequeue_script('contact-form-7'); # Restrict scripts.
        wp_dequeue_script('google-recaptcha');
        wp_dequeue_script('wpcf7-recaptcha');
		wp_dequeue_style('contact-form-7'); # Restrict css.
    }
}
add_action( 'wp_enqueue_scripts', 'erua_conditionally_load_contact7_js_css', 100 );

/**
 * Register custom Contact7 shortcode attributes.
 * 
 * https://contactform7.com/getting-default-values-from-shortcode-attributes/
 * https://wordpress.org/support/topic/contact-form-7-recipients-e-mail-as-variable/
 */
function custom_shortcode_atts_wpcf7_filter( $out, $pairs, $atts ) {

    $destination_email_attr = 'destination-email';
    $recipient_user_url_attr = 'recipient-user-url';
    $recipient_user_name_attr = 'recipient-user-name';
    $recipient_user_login_attr = 'recipient-user-login';
    $recipient_user_id_attr = 'recipient-user-id';
    
    if ( isset( $atts[$destination_email_attr] ) ) {
        $out[$destination_email_attr] = $atts[$destination_email_attr];
    }

    if ( isset( $atts[$recipient_user_url_attr] ) ) {
        $out[$recipient_user_url_attr] = $atts[$recipient_user_url_attr];
    }

    if ( isset( $atts[$recipient_user_name_attr] ) ) {
        $out[$recipient_user_name_attr] = $atts[$recipient_user_name_attr];
    }

    if ( isset( $atts[$recipient_user_login_attr] ) ) {
        $out[$recipient_user_login_attr] = $atts[$recipient_user_login_attr];
    }

    if ( isset( $atts[$recipient_user_id_attr] ) ) {
        $out[$recipient_user_id_attr] = $atts[$recipient_user_id_attr];
    }

    return $out;
}
add_filter( 'shortcode_atts_wpcf7', 'custom_shortcode_atts_wpcf7_filter', 10, 3 );

/**
 * Create custom form tags.
 * 
 * https://contactform7.com/2015/01/10/adding-a-custom-form-tag/
 * https://stackoverflow.com/questions/42792051/how-to-make-custom-form-tag-in-contact-form-7-required
 */
function contact7_add_form_tag_user_url() {
    wpcf7_add_form_tag( array('usrurl', 'usrurl*'), 'contact7_user_url_form_tag_handler', array( 'name-attr' => true ) );
}
function contact7_user_url_form_tag_handler( $tag ) {
    //return date_i18n( get_option( 'time_format' ) );
    $tag = new WPCF7_FormTag( $tag );

    if ( empty( $tag->name ) ) {
        return '';
    }

    // Get default value from [contact7] shortcode
    $value = (string) reset( $tag->values );
    $value = $tag->get_default_option( $value );
    $value = wpcf7_get_hangover( $tag->name, $value );

    //$html = '<a href="' . $value . '">' . $value . '</a>';

    $html = sanitize_url($value);

    // echo '<pre>';
    // var_dump($value);
    // echo '</pre>';

    return $html;
}
add_action( 'wpcf7_init', 'contact7_add_form_tag_user_url' );

function contact7_add_form_tag_user_name() {
    wpcf7_add_form_tag( array('usrname', 'usrname*'), 'contact7_user_name_form_tag_handler', array( 'name-attr' => true ) );
}
function contact7_user_name_form_tag_handler( $tag ) {
    //return date_i18n( get_option( 'time_format' ) );
    $tag = new WPCF7_FormTag( $tag );

    if ( empty( $tag->name ) ) {
        return '';
    }

    // Get default value from [contact7] shortcode
    $value = (string) reset( $tag->values );
    $value = $tag->get_default_option( $value );
    $value = wpcf7_get_hangover( $tag->name, $value );

    //$html = '<a href="' . $value . '">' . $value . '</a>';

    $html = sanitize_text_field($value);

    // echo '<pre>';
    // var_dump($value);
    // echo '</pre>';

    return $html;
}
add_action( 'wpcf7_init', 'contact7_add_form_tag_user_name' );

/**
 * Handle a custom special mail tag for destination email.
 * 
 * https://searchcode.com/file/307851379/wp-content/plugins/contact-form-7/includes/special-mail-tags.php/
 * https://wordpress.stackexchange.com/questions/320656/add-custom-variable-in-contact-form-7-mail-body
 * https://www.webtechideas.in/custom-contact-form-7-special-mail-tags/
 * https://docs.hookmax.com/plugin/contact-form-7/5.5.3/filter/wpcf7_special_mail_tags/
 * https://github.com/carlosdavis/wordpress-plugins/blob/master/contact-form-7/modules/special-mail-tags.php
 * https://wordpress.stackexchange.com/questions/359534/my-shortcode-is-not-working-in-contact-form-7-message-body
 * https://www.gsheetconnector.com/docs/cf7-gsheetconnector-pro/hooks-to-use-custom-mail-tags
 *
 * @param string
 * @param string
 * @param string
 *
 * @return string
 */
function contact7_special_mail_tag_destination_email( $output, $name, $html ) {
    // Special tag values are passed in format wpcf7.$name which we convert to _$name
    $name = preg_replace( '/^wpcf7\./', '_', $name ); # For backwards compatibility

    $submission = WPCF7_Submission::get_instance();
    if ( ! $submission ) {
        return $output;
    }
    else {
        $form_data = $submission->get_posted_data();
    }

    if ( '_destination_email' == $name ) {
        //$outpout = $submission->get_posted_data('_destination_email');
        //$url = $submission->get_meta( 'url' );
        $user_ID = $submission->get_posted_data('recipient-user-id');
        $user_info = null;
        $user_email = null;

        if ( !empty($user_ID) && $user_ID > 0 ) {
            $user_info = get_userdata($user_ID);
            $user_email = ( !empty($user_ID) ) ? $user_info->user_email : $user_email;

            return $output = sanitize_email( $user_email );
        }
    }

    if ( '_post_name' == $name ) {
        // Use the post_name meta field to test outputs in Flamingo's inbound messages.
        //return $output = sanitize_text_field('URL: ' .  $url . ' Hmm? ' . $submission->get_posted_data('_destination_email'));
    }

    return $output;
}
add_filter( 'wpcf7_special_mail_tags', 'contact7_special_mail_tag_destination_email', 10, 3 );

/**
 * Dynamic CC Additional Header
 * 
 * https://wordpress.org/support/topic/dynamic-cc-additional-header/
 */
function add_jobmanager_recipient($cf7)
{
    $submission = WPCF7_Submission::get_instance();

    if ( $submission ) {
        $data = $submission->get_posted_data();
        $cc_email = get_field(
            'job_contact_email_address',
            $submission->get_meta('container_post_id')
        );

        if (empty($data) || empty($cc_email)) {
            return;
        }

        $mail = $cf7->get_properties();
        $mail['mail']['additional_headers'] .= "\r\nCc: $cc_email";

        $cf7->set_properties($mail);
    }
    return $cf7;
}
//add_filter('wpcf7_before_send_mail', 'add_jobmanager_recipient', 10, 1);
