<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// Backoffice Styling
//================================================================================

/**
 * Add some CSS to WordPress's admin area.
 */
function erua_inject_admin_style() {

    $user = wp_get_current_user();
    /**
     * Hide some stuff from users, using CSS.
     */
    if ( ! in_array( 'administrator', (array) $user->roles ) ) {
        echo '<style>
        /* Hide Admin Menus
        =================================== */
        body.wp-admin #wp-admin-bar-wp-logo {
            pointer-events: none;
        }
        /* Hide UX Builder
        =================================== */
        body.wp-admin #uxbuilder-edit-button {
            display: none;
        }
        /* Hide Meta Boxes
        =================================== */
        body.wp-admin #ao_metabox {
            display: none;
        }
        /* Hide Filebird stuff @ Media Library
        =================================== */
        body.wp-admin #fbv-context-menu {
            display: none !important;
        }
        body.wp-admin #filebird-root div[class^="Toolbarstyles__Wrapper"], 
        body.wp-admin #filebird-root button[class^="Headerstyles__Button"],
        body.wp-admin #filebird-root div[class^="Searchstyles__Wrappe"],
        body.wp-admin .attachments-browser .media-sidebar .compat-field-fbv,
        body.wp-admin .media-frame-content .fbv-upload-inline,
        body.wp-admin #file-form .fbv-upload-inline {
            display: none;
        }
        body.wp-admin #filebird-root {
            display: none !important;
        }
        /*body.wp-admin #filebird-root .fb-tree-list-holder-inner > .fb-tree-treenode:is([data-id="15"],[data-id="9"], [data-id="2"]) {
            display: none !important;
        }*/
        </style>';
    }

    // https://support.advancedcustomfields.com/forums/topic/acf-blocks-cramped-in-right-sidebar-of-editor/
    // https://support.advancedcustomfields.com/forums/topic/acf-blocks-support-for-block-inspector-tabs/

    echo '<style>
    body.wp-admin #wp-admin-bar-flatsome-activate {
        display: none;
    }
    /* ACF custom Gutenberg blocks
    =================================== */
    body.wp-admin .edit-post-sidebar .acf-field.acf-field-repeater.gutenberg-sidebar-hidden,
    body.wp-admin .edit-post-sidebar .acf-fields.acfe-column-wrapper > .acf-field.acf-field-acfe-column[data-endpoint] {
        display: none !important;
    }
    body.wp-admin .block-editor .acf-block-fields .acf-tab-wrap {
        overflow: hidden;
    }
    /* "Aeiforia/ERUAHAUS Project" edit.php Status column
    =================================== */
    body.edit-php :is(.project-status) {
        display: inline-block;
        border-radius: 2px;
        padding: 4px;
        color: #fff;
        font-weight: 600;
        text-align: center;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        max-width: 100px;
    }
    body.edit-php .project-status.active-status {
        background-color: #3CA6FE;
    }
    body.edit-php .project-status.closed-status {
        background-color: #CA3F3F;
    }
    body.edit-php .project-status.generic-status {
        background-color: #1a1a1a;
    }
    /* "Membership Requests" edit.php Status column
    =================================== */
    body.edit-php :is(.request-status) {
        display: inline-block;
        border-radius: 2px;
        padding: 4px;
        color: #fff;
        font-weight: 600;
        text-align: center;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        max-width: 80px;
    }
    body.edit-php .request-status.approved-status {
        background-color: #39B54A;
    }
    body.edit-php .request-status.inprogress-status {
        background-color: #3CA6FE;
    }
    body.edit-php .request-status.pending-status {
        background-color: #3CA6FE;
    }
    body.edit-php .request-status.closed-status {
        background-color: #CA3F3F;
    }
    body.edit-php .request-status.open-status {
        background-color: #FBB03B; /* #FEDA3E */
    }
    body.edit-php .request-status.generic-status {
        background-color: #1a1a1a;
    }
    /* "Funding/Job Opportunity" edit.php Status column
    =================================== */
    body.edit-php :is(.funding-status,.job-status) {
        display: inline-block;
        border-radius: 2px;
        padding: 4px;
        color: #fff;
        font-weight: 600;
        text-align: center;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        max-width: 100px;
    }
    body.edit-php .funding-status.open-status,
    body.edit-php .job-status.open-status {
        background-color: #FBB03B;
    }
    body.edit-php .funding-status.closed-status,
    body.edit-php .job-status.closed-status {
        background-color: #CA3F3F;
    }
    body.edit-php .funding-status.forthcoming-status,
    body.edit-php .job-status.forthcoming-status {
        background-color: #3CA6FE;
    }
    body.edit-php .funding-status.generic-status,
    body.edit-php .job-status.generic-status {
        background-color: #1a1a1a;
    }
    /* "Form Applicant Details" post.php
    =================================== */
    body:is(.post-php,.post-new-php).post-type-eruahaus-project .eruahaus-project-applicant-details,
    body:is(.post-php,.post-new-php).post-type-showroom .showroom-applicant-details,
    body:is(.post-php,.post-new-php).post-type-creative-blog-post .creative-blog-applicant-details,
    body:is(.post-php,.post-new-php).post-type-event .event-applicant-details,
    body:is(.post-php,.post-new-php).post-type-post .news-applicant-details {
        background-color: #cec2c2;
    }
    /* "Hackathon" post.php
    =================================== */
    body:is(.post-php,.post-new-php).post-type-hackathon #uxbuilder-edit-button {
        display: none;
    }
    /* "Aeiforia/ERUAHAUS Project" post.php SDG
    =================================== */
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list {
        display: inline-flex !important;
        flex-wrap: wrap;
        max-width: 510px;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li {
        margin: 0;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li:not(:last-child),
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li:not(:last-child) {
        margin-right: 5px;
        margin-bottom: 5px;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list:hover > li > label > .sdg-icon,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list:hover > li > label > .sdg-icon {
        opacity: 0.4;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label.selected > .sdg-icon,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label.selected > .sdg-icon {
        opacity: 1;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label > .sdg-icon:hover,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label > .sdg-icon:hover {
        opacity: 1;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label {
        position: relative;
        display: inline-flex;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label > input[type="checkbox"],
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label > input[type="checkbox"] {
        visibility: hidden;
        margin: 0;
        position: absolute;
        top: 0;
        left: 0;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label > .sdg-icon,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label > .sdg-icon {
        display: block;
        width: 80px;
        height: 80px;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label::after,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label::after {
        display: none;
        position: absolute;
        font-family: "Font Awesome 5 Free";
        font-weight: 400;
        content: "\f111";
        font-size: 18px;
        color: #478bfb;
        right: 1px;
        top: 1px;
    }
    body:is(.post-php,.post-new-php).post-type-aeiforia-project #aeiforia-project-sdg-contribution .acf-checkbox-list > li > label.selected::after,
    body:is(.post-php,.post-new-php).post-type-eruahaus-project #eruahaus-project-sdg-contribution .acf-checkbox-list > li > label.selected::after {
        display: block;
        font-weight: 900;
        content: "\f058";
        color: #478bfb;
    }
    /* "Theme General Settings"
    =================================== */
    body.toplevel_page_theme-general-settings .big-title {
        font-size: 2em;
    }
    body.toplevel_page_theme-general-settings .module-menu-container > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row > .acf-row-handle {
        background: #908e8e;
        font-size: 1.2em;
    }
    body.toplevel_page_theme-general-settings .module-menu-container > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row > .acf-row-handle:hover > .acf-row-number {
        color: #1cc88a;
        text-shadow: none;
    }
    body.toplevel_page_theme-general-settings .module-menu-container > .acf-input > .acf-repeater > .acf-table > tbody > .acf-row > .acf-row-handle > .acf-row-number {
        color: #fcfcfc;
    }
    body.toplevel_page_theme-general-settings .module-menu-container .acf-field-image img {
        max-height: 40px !important;
    }
    /* Users.php list
    =================================== */
    body.users-php .users th#email,
    body.users-php .users th#name,
    body.users-php .users th#registered {
        width: unset;
    }
    body.users-php .users th#bbp_user_role {
        width: 10% !important;
    }
    body.users-php .users th#alg_wc_ev {
        width: 50px;
    }
    body.users-php #the-list td.has-row-actions .row-actions > span.bookings {
        display: none;
    }
    @media all and (min-width: 783px) {
        body.users-php .users th#username {
            width: 15%;
        }
    }
    </style>';
}
add_action('admin_head', 'erua_inject_admin_style');

//================================================================================
// DISABLE PAGES
//================================================================================

/**
 * Disable pages for users
 * https://developer.wordpress.org/reference/hooks/load-page-php/
 * https://wordpress.stackexchange.com/questions/195353/how-to-disable-profile-php-for-users
 */
add_action( 'load-profile.php', function() {
    if( ! current_user_can( 'manage_options' ) && function_exists( 'bp_core_get_user_domain' ) )
        exit( wp_safe_redirect( bp_core_get_user_domain( get_current_user_id() ) ) );
} );
add_action( 'load-about.php', function() {
    if( ! current_user_can( 'manage_options' ) )
        exit( wp_safe_redirect( site_url() ) );
} );

//================================================================================
// RESTRICT LISTING VIEWS
//================================================================================

/**
 * Show only posts and media related to logged in author
 *
 * https://publishpress.com/blog/hide-peoples-posts-wordpress-admin/
 * https://wordpress.stackexchange.com/questions/49154/hide-other-users-posts-in-admin-panel
 */
function erua_query_set_only_author( $wp_query ) {
    global $current_user;
    if( is_admin() && !current_user_can('manage_options') ) {
        $wp_query->set( 'author', $current_user->ID );
        //add_filter('views_edit-post', 'fix_post_counts');
        //add_filter('views_upload', 'fix_media_counts');
    }
}
add_action('pre_get_posts', 'erua_query_set_only_author' );

//================================================================================
// Admin Login Screen - Theming
//================================================================================

/**
* Include a custom wp admin login style sheet.
*/
function erua_admin_login_stylesheet() {
    wp_enqueue_style( 'erua-custom-login', get_stylesheet_directory_uri() . '/assets/css/wp-admin-login.css' );
}
add_action( 'login_enqueue_scripts', 'erua_admin_login_stylesheet' );

/**
* URL where the login logo points to.
*/
function erua_admin_login_logo_url() {
    return home_url();
}
add_filter( 'login_headerurl', 'erua_admin_login_logo_url' );

/**
* Title of the login logo.
*/
function erua_admin_login_logo_text() {
    return __('ECOs PLATFORM', 'erua');
}
add_filter( 'login_headertext', 'erua_admin_login_logo_text' );

//================================================================================
// TAXONOMIES
//================================================================================

/**
 * Hide various Gutenberg meta boxes of Taxonomies at a Post's editing screen, 
 * when meta_box_cb is set to false for the specific Taxonomy.
 *
 * https://wordpress.org/support/topic/remove-the-taxonomy-from-the-sidebar-in-gutenberg/
 * https://github.com/WordPress/gutenberg/issues/13816#issuecomment-470137667
 */
function handle_gutenberg_meta_boxes( $response, $taxonomy, $request ) {

    //if ( $taxonomy->slug = 'aeiforia-project-status' ) {

        $context = ! empty( $request['context'] ) ? $request['context'] : 'view';

        // Context is edit in the editor
        if( $context === 'edit' && $taxonomy->meta_box_cb === false ) {

            $data_response = $response->get_data();

            $data_response['visibility']['show_ui'] = false;

            $response->set_data( $data_response );
        }
    //}

    return $response;
}
add_filter( 'rest_prepare_taxonomy', 'handle_gutenberg_meta_boxes', 10, 3);

/**
 * Hide various meta boxes at a Post's editing screen.
 */
function handle_classic_meta_boxes() {
    //$user = wp_get_current_user();

    remove_meta_box( 'project-status', ['aeiforia-project'], 'side' );

    // if ( in_array( 'shop_manager', (array) $user->roles ) ) {
    //     remove_meta_box( 'icl_div', ['page', 'post', 'product', 'woodmart_slide'], 'side' );
    //     //remove_meta_box( 'redux-cl_redata-metabox-blog-options', ['page', 'post', 'product'], 'normal' );
    // }
}
//add_action( 'add_meta_boxes', 'handle_classic_meta_boxes', 999);

//================================================================================
// TWEAKS
//================================================================================

/**
 * Custom Logo for WP Admin Bar
 */
function erua_dashboard_custom_logo() {
    // background-image: url(' . get_bloginfo('stylesheet_directory') . '/images/admin/dashboard-logo-icon.svg) !important;

    echo '
    <style type="text/css">
      #wpadminbar #wp-admin-bar-wp-logo > .ab-item .ab-icon:before {
          background-image: url("' . site_url() . '/wp-content/uploads/2023/09/favicon-32x32-1.png") !important;
          background-position: 0 0;
          color: rgba(255, 255, 255, 0);
          /*backdrop-filter: invert(70%);*/
          background-repeat:no-repeat;
          background-size: cover;
      }
      #wpadminbar #wp-admin-bar-wp-logo.hover > .ab-item .ab-icon {
          background-position: 0 0;
      }
      #wpadminbar #wp-admin-bar-wp-logo > .ab-sub-wrapper {
          display: none;
      }
    </style>
    ';
}
//hook into the administrative header output
add_action('wp_before_admin_bar_render', 'erua_dashboard_custom_logo');

// Remove dashboard widgets
function erua_remove_dashboard_meta() {

    remove_meta_box( 'dashboard_primary', 'dashboard', 'normal' ); # WordPress Events and News
    remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' ); # Quick Draft
    remove_meta_box( 'em_booking_stats', 'dashboard', 'normal' ); # Events Manager Bookings

    if ( ! current_user_can( 'manage_options' ) ) {
        // remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
        // remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
        // remove_meta_box( 'dashboard_secondary', 'dashboard', 'normal' );
        // remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );
        // remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
        // remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
    }

}
add_action( 'admin_init', 'erua_remove_dashboard_meta' );

// Custom Admin footer
function erua_remove_default_admin_footer () {
	echo '<span id="footer-thankyou" style="margin-right: 5px;">Powered by <a href="//erua-eui.eu/" target="_blank">ERUA</a></span>';

    if ( is_admin() && ! current_user_can( 'manage_options' ) ) {
        add_filter( 'update_footer', '__return_empty_string', 11 );
    }
}
add_filter( 'admin_footer_text', 'erua_remove_default_admin_footer' );

/**
 * Correct the user permalink that was placed by ACF Extended,
 * at the profile.php and user-edit.php of the backoffice,
 * and add the missing username at the end of the URL.
 *
 * https://weusewp.com/tutorial/change-author-url-slug-base/
 */
function erua_backoffice_profile_modding( $user ) {
    $username = $user->data->user_nicename;
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function(event) {
        const editSlugBox = document.getElementById('edit-slug-box');
        const anchor = editSlugBox.querySelector('a');
        const permalink = anchor.innerText;
        //console.log(editSlugBox);
        //console.log(permalink);
        anchor.href = permalink + '<?php echo $username; ?>/';
        anchor.innerText = permalink + '<?php echo $username; ?>/';
    }, { capture: false, once: true });
    </script>
    <?php
}
//add_action( 'show_user_profile', 'erua_backoffice_profile_modding' );
//add_action( 'edit_user_profile', 'erua_backoffice_profile_modding' );

//-------------------------------------------------------------------
// CUSTOM DASHBOARD WIDGETS
//-------------------------------------------------------------------

//require_once __DIR__ . '/dashboard-widgets.php'; # stats
