<?php
/*
Table of contents:

.. (1) Helper Functions (reusable code).
.. (2) Theme Setup.
.. (3) Theme Widgets.
.. (4) Theme Redirects.
.. (5) Theme Search setup.
.. (6) Shop Customizations.
.. (7) SHORTCODES.
.. (8) Backoffice Customizations.
.. (9) AEIFORIA-RELATED.
.. (10) ERUAHAUS-RELATED.
.. (11) PARTNERSHIPS-RELATED.
.. (12) SCIENCE-SOCIETY-RELATED.
.. (13) NEWS-EVENTS-RELATED.
.. (14) USER ACCOUNTS.
*/

// Let PHP Show All Errors
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Disable automatic updates for plugins.
add_filter( 'auto_update_plugin', '__return_false' );
// Disable automatic updates for themes.
add_filter( 'auto_update_theme', '__return_false' );

//-------------------------------------------------------------------
// (1) Helper Functions (reusable code).
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/helpers.php';

//-------------------------------------------------------------------
// (2) Theme Setup (Styles, Scripts, Languages).
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/theme-setup.php';
require_once __DIR__ . '/includes/acf-customizations.php';
//require_once __DIR__ . '/includes/contact7-customizations.php';
require_once __DIR__ . '/includes/flatsome-theme-tweaks.php';
require_once __DIR__ . '/includes/media-library-customizations.php';
require_once __DIR__ . '/includes/buddypress-customizations.php';

//-------------------------------------------------------------------
// (3) Theme Widgets.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/widgets/load-widgets.php';

//-------------------------------------------------------------------
// (4) Theme Redirects.
//-------------------------------------------------------------------

//require_once __DIR__ . '/includes/theme-redirects.php';

//-------------------------------------------------------------------
// (5) Theme Search setup.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/theme-search.php';

//-------------------------------------------------------------------
// (6) Shop Customizations.
//-------------------------------------------------------------------

//require_once __DIR__ . '/includes/shop-customizations.php';

//-------------------------------------------------------------------
// (7) SHORTCODES.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/theme-shortcodes.php';

//-------------------------------------------------------------------
// (8) Backoffice Customizations.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/backoffice-customizations.php';

//-------------------------------------------------------------------
// (9) AEIFORIA-RELATED.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/aeiforia/module-menu.php';
require_once __DIR__ . '/includes/aeiforia/cpt-config.php';
require_once __DIR__ . '/includes/aeiforia/ajax-operations.php';

//-------------------------------------------------------------------
// (10) ERUAHAUS-RELATED.
//-------------------------------------------------------------------

//require_once __DIR__ . '/includes/eruahaus/email-notifications.php';
require_once __DIR__ . '/includes/eruahaus/module-menu.php';
require_once __DIR__ . '/includes/eruahaus/cpt-config.php';
require_once __DIR__ . '/includes/eruahaus/ajax-operations.php';
require_once __DIR__ . '/includes/eruahaus/projects-form.php'; 

//require_once __DIR__ . '/includes/eruahaus/membership-request/email-notifications.php';
require_once __DIR__ . '/includes/eruahaus/membership-request/cpt-config.php';
require_once __DIR__ . '/includes/eruahaus/membership-request/requests-form.php';

//require_once __DIR__ . '/includes/eruahaus/showroom/email-notifications.php';
require_once __DIR__ . '/includes/eruahaus/showroom/cpt-config.php';
require_once __DIR__ . '/includes/eruahaus/showroom/ajax-operations.php';
require_once __DIR__ . '/includes/eruahaus/showroom/events-form.php';
require_once __DIR__ . '/includes/eruahaus/showroom/showroom-form.php';

//require_once __DIR__ . '/includes/eruahaus/blog/email-notifications.php';
require_once __DIR__ . '/includes/eruahaus/blog/cpt-config.php';
require_once __DIR__ . '/includes/eruahaus/blog/creative-blog-form.php';

//-------------------------------------------------------------------
// (11) PARTNERSHIPS-RELATED.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/partnerships/module-menu.php';

//-------------------------------------------------------------------
// (12) SCIENCE-SOCIETY-RELATED.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/science-society/module-menu.php';
require_once __DIR__ . '/includes/science-society/funding-opportunities/ajax-operations.php';
require_once __DIR__ . '/includes/science-society/funding-opportunities/cpt-config.php';
require_once __DIR__ . '/includes/science-society/hackathons/cpt-config.php';
require_once __DIR__ . '/includes/science-society/job-opportunities/ajax-operations.php';
require_once __DIR__ . '/includes/science-society/job-opportunities/cpt-config.php';

//-------------------------------------------------------------------
// (13) NEWS-EVENTS-RELATED.
//-------------------------------------------------------------------

require_once __DIR__ . '/includes/news-events/module-menu.php';

//require_once __DIR__ . '/includes/news-events/events/email-notifications.php';
require_once __DIR__ . '/includes/news-events/events/cpt-config.php';
require_once __DIR__ . '/includes/news-events/events/events-form.php'; 

//require_once __DIR__ . '/includes/news-events/blog/email-notifications.php';
require_once __DIR__ . '/includes/news-events/blog/cpt-config.php';
require_once __DIR__ . '/includes/news-events/blog/news-form.php';

//-------------------------------------------------------------------
// (14) USER ACCOUNTS.
//------------------------------------------------------------------

require_once __DIR__ . '/includes/user-account/ajax-operations.php';

//-------------------------------------------------------------------
// DEBUGGING.
//-------------------------------------------------------------------

//require_once __DIR__ . '/includes/debugger.php';
