'use strict';

const DEVICE_SUPPORTS_TOUCH = !!('ontouchstart' in window || navigator.msMaxTouchPoints);

//-------------------------------------------------------------------
// GUI ESSENTIALS
//-------------------------------------------------------------------

document.addEventListener('DOMContentLoaded', function(event) {

    /*===================================================================
        WOOCOMMERCE MESSAGES
    ===================================================================*/

    const wcMessages = document.querySelectorAll('body:not(.woocommerce-page) #wrapper > .message-wrapper');

    if ( wcMessages !== null ) {
        // Add a custom close button for WooCommerce messages.
        wcMessages.forEach((message) => {

            const closeButton = document.createElement('div');
            closeButton.className = 'closeButton';
            closeButton.title = 'close message';
            closeButton.innerHTML = '&times;';
            message.prepend(closeButton);

            //const closeButton = window.getComputedStyle(message, '::before');

            if ( closeButton.length != 0 ) {
                /**
                 * Make the custom X (close button) of the message box,
                 * to actually close the message box when clicked.
                 */
                closeButton.addEventListener('click', () => {
                    if ( !message.classList.contains('hidden') ) {
                        message.classList.add('hidden');
                    }
                });
            }

        });
    }

    /*===================================================================
        PROJECT TABLE OF CONTENTS - LINK SCROLLING
    ===================================================================*/

    /**
     * Select all main menu anchors with internal links.
     * 
     * Smooth scrolling when clicking an anchor link:
     * https://stackoverflow.com/questions/7717527/smooth-scrolling-when-clicking-an-anchor-link
     */
    if ( ! DEVICE_SUPPORTS_TOUCH ) {

        const tocLinks = document.querySelectorAll('.accordion.table-of-contents .accordion-inner .toc-link')
        
        if ( tocLinks !== null ) {
            tocLinks.forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();

                    const href = this.getAttribute('href');

                    // If the anchor's href contains a #
                    if ( href.indexOf('#') !== -1 ) {

                        //let anchorURL = href.split('#')[0];
                        let anchorHash = href.split('#')[1];

                        const linkedElement = document.getElementById(anchorHash);

                        //console.log(linkedElement);

                        // Smoothly scroll to the internal link
                        // https://forum.ionicframework.com/t/scrollintoview-not-working-on-android/193746/2
                        if ( linkedElement ) {
                            linkedElement.scrollIntoView({
                                behavior: 'smooth'
                            });
                        }

                    }

                });
            });
        }
    }

    /*===================================================================
        SITE SIDE NAVIGATION
    ===================================================================*/

    const sideNav = document.getElementById('sideNav');
    //const sideNavMenuItems = document.querySelectorAll('body:not(.woocommerce-page) #sideNavMenu > .menu-item');
    const sideNavToggle = document.getElementById('sideNavToggle');

    if ( sideNav !== null && sideNavToggle !== null ) {
        // Expand or collapse the left side navigation menu.
        sideNavToggle.addEventListener('click', () => {
            document.body.classList.toggle('sidenav-expanded');
            sideNav.classList.toggle('expanded');
        });
    }

    /*===================================================================
        MODULE DROPDOWN NAVIGATION
    ===================================================================*/

    const drodpownMenuToggles = document.querySelectorAll('body:not(.woocommerce-page) .erua-navbar a.dropdown-toggle');
    //const drodpownMenus = document.querySelectorAll('body:not(.woocommerce-page) .erua-navbar .dropdown-menu');

    if ( drodpownMenuToggles !== null ) {
        drodpownMenuToggles.forEach((drodpownMenuToggle) => {
            drodpownMenuToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                const dropdownMenu = drodpownMenuToggle.parentNode.querySelector('.dropdown-menu');

                // Show or hide dropdown menus.
                if ( ! drodpownMenuToggle.classList.contains('show') ) {

                    // Hide all other open menus first
                    drodpownMenuToggles.forEach((dmt) => {
                        if ( dmt != drodpownMenuToggle && dmt.classList.contains('show') ) {
                            dmt.classList.remove('show');
                        }
                    });

                    // Show this menu
                    drodpownMenuToggle.classList.add('show');

                    // Hide the menu when there's another click
                    document.addEventListener('click', function closeDropdown(e) {

                        // If the click was not in the dropdown
                        if ( e.target !== drodpownMenuToggle && !drodpownMenuToggle.contains(e.target) && !dropdownMenu.contains(e.target) ) {
                            if ( drodpownMenuToggle.classList.contains('show') ) drodpownMenuToggle.classList.remove('show');

                        }
                        // Else if it was in the dropdown, don't hide it, add another one-time event
                        else if ( e.target === dropdownMenu || dropdownMenu.contains(e.target) ) {
                            document.addEventListener('click', closeDropdown, { capture: false, once: true });
                        }

                    }, { capture: false, once: true });

                }
                else {
                    drodpownMenuToggle.classList.remove('show');
                }

            }, true);
        });
    }

    /*===================================================================
        ARCHIVE - COLLAPSIBLE MOBILE FILTERS
    ===================================================================*/

    const mobileFiltersButton = document.querySelector('#mobile-filters > button');

    if ( mobileFiltersButton ) {
        mobileFiltersButton.addEventListener('click', e => {
            const selector = e.target.getAttribute('data-target');
            e.target.classList.toggle('open-target');
            collapseFilters(selector, 'toggle');
        });
    }

    const fnmap = {
    'toggle': 'toggle',
    'show': 'add',
    'hide': 'remove' };

    const collapseFilters = (selector, cmd) => {
        const targets = Array.from(document.querySelectorAll(selector));
        targets.forEach(target => {
            target.classList[fnmap[cmd]]('show');
        });
    };

}, { capture: false, once: true });
