jQuery(document).ready(function () {

    var timeout;
    const DELAY = 500; // ms
    const debugBox = document.getElementById('debug');
    const ajaxLoader = document.getElementById('ajax-loader');
    const searchForm = document.getElementById('showroom-search-form');
    const searchFormInputs = searchForm.querySelectorAll("input[type='radio']");

    /**
     * AJAX-update the ShowRoom listings
     */
    function sendForm() {
    //jQuery(searchForm).submit(function(e) {
        //e.preventDefault();
        //console.log('Searching ShowRoom...');

        clearTimeout(timeout);
        /**
         * Throttle execution of AJAX requests
         * https://stackoverflow.com/questions/6967785/ways-to-throttle-ajax-requests
         */
        timeout = setTimeout(function() {

            // Show a loading indicator
            if ( ! ajaxLoader.classList.contains('show') ) ajaxLoader.classList.add('show');

            /*-------------------------------------------------------------------
                GET & PREPARE FORM DATA
            -------------------------------------------------------------------*/

            // Encode as a query string ("application/x-www-form-urlencoded")
            //const formData = jQuery(this).serialize();
            //console.log(formData);

            // Encodes the set of form elements as an array of names and values.
            const formDataArray = jQuery(searchForm).serializeArray();
            //console.log(formDataArray);
            const formDataJSON = {};
            // Convert the array to JSON
            jQuery.each(formDataArray, function () {
                // Remove these form elements
                $tempArray = [ "_acf_form", "acf[_validate_email]" ];
                if ( $tempArray.includes( this.name ) ) return;

                if ( this.name.startsWith('acf[') ) {
                    let fieldKey = this.name.match(/\[(.*?)\]/);
                    //formDataJSON[fieldKey[1]] = this.value || "";
                    // Create key if not present
                    if ( ! formDataJSON.hasOwnProperty(fieldKey[1]) ) formDataJSON[fieldKey[1]] = [];
                    // Populate key with a value
                    if ( typeof this.value === 'string' && this.value !== '' ) formDataJSON[fieldKey[1]].push(this.value);
                }
                else {
                    formDataJSON[this.name] = this.value || "";
                }
            });
            //console.log(formDataJSON);

            /*-------------------------------------------------------------------
                AJAX POST
            -------------------------------------------------------------------*/

            //return false; // don't submit

            // https://www.w3schools.com/jquery/ajax_ajax.asp
            jQuery.ajax({
                type: 'POST',
                dataType : 'JSON', // expected server response format
                //contentType: 'application/json; charset=utf-8', // format to send to server
                url: ajax_object._ajax_url, // provided by wp_localize_script()
                data: {
                    action: ajax_object._ajax_action, // provided by wp_localize_script()
                    ajaxnonce: ajax_object._ajax_nonce, // provided by wp_localize_script()
                    //ajaxpostid: ajax_object._ajax_post_id, // provided by wp_localize_script()
                    query_args: ajax_query_data.query, // provided by wp_localize_script()
                    form_data: formDataJSON,
                },
                success: function (response, textStatus, XMLHttpRequest) {

                    // Adjust the URLs of the category filters
                    //var original_url = (new URLSearchParams(decodeURIComponent(this.data)).get('original_url'));
                    // jQuery('#filters-container .katigoria').each(function () {
                    //     var $this = $(this);
                    //     var _href = $this.attr('href');
                    //     var tempURL = _href.split('?', 1);
                    //     $this.attr('href', tempURL + '?statusfilter=' + metavalue);
                    // });

                    //console.log(typeof acf !== 'undefined');

                    //history.pushState(null, null, response.data.query_string);
                    //history.pushState(null, null, '/' + response.data.base_url + response.data.query_string);
                    //history.replaceState(null, null, response.data.query_string);
                    //history.replaceState({}, document.title, location.origin + '/' + response.data.base_url + response.data.query_string);
                    history.replaceState({}, document.title, '/' + response.data.base_url + response.data.query_string);
                    //history.replaceState(null, null, '/' + response.data.base_url + response.data.query_string);
                    // console.log(response.data.base_url);
                    // console.log(response.data.query_string);

                    // Print new results
                    //console.log(response);

                    // jQuery('#debug').html('<pre>'+JSON.stringify(response.data.query_string)+'</pre>');
                    // jQuery('#debug').append('<pre>'+JSON.stringify(response.data.wp_query_args)+'</pre>');
                    // jQuery('#debug').append('<pre>'+JSON.stringify(response.data.results)+'</pre>');
                    //jQuery('#debug').html(response);
                    //debugBox.innerHTML = response.data.html;

                    //jQuery('#presentations-container').html(response);
                    jQuery('#presentations-container').html(response.data.html);
                    setTimeout(() => {
                        // Remove loading indicator
                        if ( ajaxLoader.classList.contains('show') ) ajaxLoader.classList.remove('show');
                    }, 900);
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    console.log('An error occurred while AJAX posting.');
                    //alert(errorThrown);
                    //alert(XMLHttpRequest.responseText);
                }
            });

        }, DELAY);
    }

   /**
    * Submit form data when checkbox state changes.
    * 
    * https://stackoverflow.com/questions/35171748/submit-form-via-ajax-method-on-change-of-select-field
    * https://stackoverflow.com/questions/6480316/jquery-submit-form-onchange
    */
    searchFormInputs.forEach((input) => {
        input.addEventListener('change', () => {
            //console.log('Will submit form');
            sendForm();
        });
    });


});
