/**
 * AJAX-sync the content lists whenever a sync click event occurs.
 */
jQuery(document).ready(function () {
    var timeout;
    const DELAY = 500; // ms
    const ajaxLoader = document.getElementById('ajax-loader');
    const contentTypeOptions = document.querySelectorAll('.post-types-list .content-link');

    /**
     * Highlight the type of content that was clicked on.
     */
    function highlightPostType(postType) {
        if ( contentTypeOptions !== null && postType ) {
            contentTypeOptions.forEach((option) => {
                if ( option.parentElement.classList.contains('active') && !option.parentElement.classList.contains(postType) ) {
                    option.parentElement.classList.remove('active');
                }
                else if ( option.parentElement.classList.contains(postType) && !option.parentElement.classList.contains('active') ) {
                    option.parentElement.classList.add('active');
                }
            });
        }
    }

    if ( contentTypeOptions !== null ) {
        contentTypeOptions.forEach((option) => {
            option.addEventListener('click', function (e) {
                e.preventDefault();

                clearTimeout(timeout);
                /**
                 * Throttle execution of AJAX requests
                 * https://stackoverflow.com/questions/6967785/ways-to-throttle-ajax-requests
                 */
                timeout = setTimeout(function() {

                    // Show a loading indicator
                    if ( ! ajaxLoader.classList.contains('show') ) ajaxLoader.classList.add('show');

                    let postType = '';
                    if ( option.hasAttribute('data-post-type') ) postType = option.dataset.postType;
                    highlightPostType(postType);

                    //console.log(ajax_object);

                    jQuery.ajax({
                        type: 'POST',
                        dataType : 'JSON', // expected server response format
                        //contentType: 'application/json; charset=utf-8', // format to send to server
                        url: ajax_object._ajax_url, // provided by wp_localize_script()
                        data: {
                            action: ajax_object._ajax_action, // provided by wp_localize_script()
                            ajaxnonce: ajax_object._ajax_nonce, // provided by wp_localize_script()
                            query_args: ajax_query_data.query, // provided by wp_localize_script()
                            post_type: postType
                        },
                        success: function (response, textStatus, XMLHttpRequest) {

                            //console.log(response);
                            history.replaceState({}, document.title, '/' + response.data.base_url + response.data.query_string);

                            /**
                             * Define the element of the current page, 
                             * of which the content is to be replaced.
                             */
                            jQuery('#contributions-wrapper').html(response.data.html);
                            setTimeout(() => {
                                // Remove loading indicator
                                if ( ajaxLoader.classList.contains('show') ) ajaxLoader.classList.remove('show');
                            }, 900);
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            console.log('An error occurred while AJAX posting.');
                            //alert(errorThrown);
                            //alert(XMLHttpRequest.responseText);
                        }
                    });
                }, DELAY);

            });
        });
    }

    /**
     * This will fire whenever the sync icon is pressed.
     */
    jQuery('#contributions-wrapper').on('click', '#contributions-sync-button', {}, function (e) {
        e.preventDefault();
        //console.log('Syncing...');
        //console.log(ajax_query_data.query);

        let postType = '';
        if ( this.hasAttribute('data-post-type') ) postType = this.dataset.postType;

        jQuery.ajax({
            type: 'POST',
            dataType : 'JSON', // expected server response format
            //contentType: 'application/json; charset=utf-8', // format to send to server
            url: ajax_object._ajax_url, // provided by wp_localize_script()
            data: {
                action: ajax_object._ajax_action, // provided by wp_localize_script()
                ajaxnonce: ajax_object._ajax_nonce, // provided by wp_localize_script()
                query_args: ajax_query_data.query, // provided by wp_localize_script()
                post_type: postType
            },
            success: function (response, textStatus, XMLHttpRequest) {
                const syncButton = jQuery('#contributions-sync-button');
                if (syncButton) jQuery(syncButton).toggleClass('rotate-sync');

                //console.log(response);
                history.replaceState({}, document.title, '/' + response.data.base_url + response.data.query_string);

                /**
                 * Define the element of the current page, 
                 * of which the content is to be replaced.
                 */
                setTimeout(function () {
                    jQuery('#contributions-wrapper').html(response.data.html);
                    //jQuery('#contributions-wrapper i.fa-chevron-left').addClass('collapsed');
                }, 1000);  // The milliseconds to wait before executing this block

            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                console.log('An error occurred while AJAX posting.');
                //alert(errorThrown);
                //alert(XMLHttpRequest.responseText);
            }
        });
    });
});
