<?php
/**
 * Plugin Name: Youzify - BuddyPress Member Types
 * Plugin URI:  https://www.youzify.com/downloads/buddypress-member-types
 * Description: BuddyPress Member Types plugin is the best way to create and manage unlimited member types easily, and get a separate directory for each member type.
 * Version:     2.0.1
 * Author:      Youssef Kaine
 * Author URI:  https://www.kainelabs.com
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: youzify-member-types
 * Domain Path: /languages/
 */
if ( ! defined( 'WPINC' ) ) {
    die;
}

if ( ! class_exists( 'BuddyPress' ) ) {
    add_action( 'admin_notices', function() {
        echo '<div class="error"><p><strong>' . sprintf( esc_html__( 'Youzify - Member Types requires BuddyPress to be installed and active. You can download %s here.', 'youzify-member-types' ), '<a href="https://wordpress.org/plugins/buddypress/" target="_blank">BuddyPress</a>' ) . '</strong></p></div>';
    } );
    return;
}

// Plugin File.
define( 'YOUZIFY_MT_FILE', __FILE__ );

// Plugin Basename
define( 'YOUZIFY_MT_BASENAME', plugin_basename( __FILE__ ) );

// Plugin Version.
define( 'YOUZIFY_MT_VERSION', '2.0.1' );

// Plugin Path.
define( 'YOUZIFY_MT_PATH', plugin_dir_path( __FILE__ ) );

// Plugin URL.
define( 'YOUZIFY_MT_URL', plugin_dir_url( __FILE__ ) );

// Public & Admin Core Path's
define( 'YOUZIFY_MT_PUBLIC', YOUZIFY_MT_PATH . 'public/' );
define( 'YOUZIFY_MT_ADMIN', YOUZIFY_MT_PATH . 'admin/' );

// Assets ( Public Assets & Admin Assets ).
define( 'YOUZIFY_MT_ASSETS', plugin_dir_url( __FILE__ ) . 'public/assets/' );
define( 'YOUZIFY_MT_ADMIN_ASSETS', plugin_dir_url( __FILE__ ) . 'admin/assets/' );

/**
 * Init Member Types.
 */
add_action( 'plugins_loaded', 'youzify_member_types_init', 15 );

function youzify_member_types_init() {

	// Init.
	require YOUZIFY_MT_PATH . 'class-youzify-member-types.php';

	global $Youzify_Member_Types;

	// Init Class
	$Youzify_Member_Types = new Youzify_Member_Types();

	// Init Admin
	if ( is_admin() ) {

        if ( ! class_exists( 'Youzify_Admin' ) ) {
            include YOUZIFY_MT_ADMIN . 'panel/youzify-admin.php';
        }

	    require_once YOUZIFY_MT_ADMIN . 'class-youzify-member-types-admin.php';

	}

}