<?php

/**
 * Get Option
 */
function youzify_member_types_option( $option, $default = null ) {

    if ( ! is_multisite() ) {
        $option_value = get_option( $option, $default );
    } else {
        if ( apply_filters( 'youzify_activate_blog_mode', true, $option ) ) {
            $option_value = get_blog_option( null, $option, $default );
        } else {
            $option_value = get_site_option( $option, $default );
        }
    }

    return $option_value;
}

/**
 * Get Registration Member Types List
 */
function youzify_get_registration_member_types() {

    // Get All Member Types Data
    $member_types = bp_get_member_types( array(), 'objects' );

    if ( is_admin() || empty( $member_types ) ) {
        return $member_types;
    }

    foreach ( $member_types as $type_id => $member_type ) {

        if ( ! isset( $member_type->db_id ) ) {
            continue;
        }

        if ( ( bp_is_current_component( 'profile' ) && ! get_term_meta( $member_type->db_id, 'youzify_type_show_in_profile_settings', true ) ) || ( bp_is_register_page() && ! get_term_meta( $member_type->db_id, 'youzify_type_show_in_registration', true ) ) ) {
            unset( $member_types[ $type_id ] );
        }

    }

    return apply_filters( 'youzify_registration_member_types', $member_types );

}

/**
 * Get Member Types
 */
// function youzify_get_member_types() {
    // Get All Member Types Data
    // return apply_filters( 'youzify_member_types',  );
// }

//     // Get All Member Types
//     $member_types = youzify_member_types_option( 'youzify_member_types' );

//     if ( empty( $member_types ) ) {
//         return false;
//     }

//     // Register Types.
//     foreach ( $member_types as $type ) {

//         if ( isset( $type['name'] ) && empty( $type['name'] )  ) {
//             continue;
//         }

//         // Get Type Slug
//         $type_slug = isset( $type['slug'] ) && ! empty( $type['slug'] ) ? $type['slug'] : false;

//         // Make the id lowercase.
//         $type_id = isset( $type['id'] ) ? $type['id'] : youzify_get_member_type_id( $type['singular'] );

//         // Register Type
//         bp_register_member_type( $type_id, array(
//             'labels' => array(
//                 'name' => $type['name'],
//                 'singular_name' => $type['singular'],
//             ),
//             'has_directory' => $type_slug
//             )
//         );

//     }
// }

// add_action( 'bp_register_member_types', 'youzify_register_member_types' );

/**
 * Add "Member Types" Field
 */
function youzify_add_member_types_field( $fields ) {

    // Get New Fields.
    $new_fields = array( 'member_types' => 'YOUZIFY_XProfile_Field_Type_MemberType' );

    // Get Fields.
    return array_merge( $fields, $new_fields );

}

add_filter( 'bp_xprofile_get_field_types', 'youzify_add_member_types_field' );

/**
 * Disable All Members type if No Member Type was Selected.
 */

// add_action( 'xprofile_data_before_save', 'youzify_member_types_disabled_member_types' );

function youzify_member_types_disabled_member_types( $field ) {

    if ( ! empty( $field->value ) ) {

        // Get Field Value.
        $types = maybe_unserialize( $field->value );

        if ( is_array( $types ) && in_array( 'no_member_type', $types ) ) {
            $field->value = serialize( array( 'no_member_type' ) );
        }

    }

}

/**
 * Update the member type of a user when member type field is updated.
 */
add_action( 'xprofile_data_after_save', 'youzify_update_member_type', 999 );

function youzify_update_member_type( $data_field ) {

    // Avoid Conflicting with Users Page Bulk Action.
    if ( is_admin() ) {

        global $pagenow;

        if ( $pagenow == 'users.php' && ! isset( $_GET['page'] ) ) {
            return;
        }

    }

    // Get Field.
    $field = xprofile_get_field( $data_field->field_id );

    // Check if field type is member types.
    if ( 'member_types' != $field->type ) {
        return ;
    }

    // Get User ID.
    $user_id = $data_field->user_id;

    // Get Member Type.
    $member_types = maybe_unserialize( $data_field->value );

    if ( empty( $member_types ) ) {

        if ( 'on' == youzify_member_types_option( 'youzify_allow_no_member_type', 'off' ) ) {

            // Remove Member Type.
            bp_set_member_type( $user_id, '' );

            // Assign No Member Type Role.
            if ( ! user_can( $user_id, 'manage_options' ) ) {

                // Get No Member Type Result
                $no_type_roles = get_option( 'youzify_member_type_no_type_roles' );

                if ( ! empty( $no_type_roles ) ) {

                    // Get User.
                    $user = new WP_User( $user_id );

                    // Disable All Old Roles.
                    $user->set_role( '' );

                    // Assign Roles.
                    foreach ( $no_type_roles as $role ) {
                        $user->add_role( $role );
                    }

                }

            }

        } else {

            // Get Default Member Type
            $default_type = youzify_member_types_option( 'youzify_default_member_type' );

            if ( ! empty( $default_type ) ) {

                // Set Default Member Type
                bp_set_member_type( $user_id, $default_type );

                // Update Member Type Field.
                xprofile_set_field_data( youzify_member_types_get_xprofile_member_types_field(), $user_id, array( $default_type ) );

                // Sync WordPress Roles.
                yzmt_assign_wordpress_roles( $user_id, $default_type );
            }

        }


        return;

    }

    if ( is_array( $member_types )  ) {

        // Remove Member Type.
        bp_set_member_type( $user_id, '' );

        foreach ( $member_types as $member_type ) {

            // Set Member Type.
            bp_set_member_type( $user_id, $member_type, true );

        }

    } else {

        // Set Member Type.
        bp_set_member_type( $user_id, $member_types );

    }

    // Sync WordPress Roles.
    yzmt_assign_wordpress_roles( $user_id, $member_types );

}

/**
 * Check if is Member Types Active.
 */
function youzify_is_member_types_active() {
    return apply_filters( 'youzify_is_member_types_active', true );
}

/**
 * Update User Role on removing Member Type
 */
function youzify_member_type_update_on_remove( $user_id, $member_type ) {

    // Get User Member Types
    $member_types = bp_get_member_type( $user_id, false );

    if ( empty( $member_types ) ) {

        if ( 'on' == youzify_member_types_option( 'youzify_allow_no_member_type', 'off' ) ) {

            // Remove Member Type.
            bp_set_member_type( $user_id, '' );

            // Assign No Member Type Role.
            if ( ! user_can( $user_id, 'manage_options' ) ) {

                // Get No Member Type Result
                $no_type_roles = get_option( 'youzify_member_type_no_type_roles' );

                if ( ! empty( $no_type_roles ) ) {

                    // Get User.
                    $user = new WP_User( $user_id );

                    // Disable All Old Roles.
                    $user->set_role( '' );

                    // Assign Roles.
                    foreach ( $no_type_roles as $role ) {
                        $user->add_role( $role );
                    }

                }

            }

        }
    }

}

add_action( 'bp_remove_member_type', 'youzify_member_type_update_on_remove', 10, 2 );
/**
 * Hide Member Types Field
 */
function youzify_hide_xprofile_member_type_field( $retval ) {

    if ( ! bp_is_active( 'xprofile' ) ) {
        return false;
    }

    // Get "Member Types" Field.
    $member_types_fields = youzify_member_types_get_xprofile_member_types_field();

    if ( empty( $member_types_fields ) ) {
        return $retval;
    }

    // Make Admins Able to edit Member types fields.
    if ( is_super_admin() ) {
        return $retval;
    }

    // Remove field from edit tab
    if ( bp_is_user_profile_edit() && 'off' == youzify_member_types_option( 'youzify_enable_member_types_modification', 'on' ) ) {
        $retval['exclude_fields'] = $member_types_fields;
    }

    // Allow field on register page
    if ( bp_is_register_page() && 'off' == youzify_member_types_option( 'youzify_enable_member_types_registration', 'on' ) ) {
        $retval['exclude_fields'] = $member_types_fields;
    }

    // Hide the field on profile view tab
    if ( ! bp_is_register_page() && ! bp_is_user_profile_edit() && ( empty( bp_get_profile_field_data( 'field=' . $member_types_fields ) ) || 'off' == youzify_member_types_option( 'youzify_enable_member_types_in_infos', 'on' ) ) ) {
        $retval['exclude_fields'] = $member_types_fields;
    }

    return $retval;
}

add_filter( 'bp_after_has_profile_parse_args', 'youzify_hide_xprofile_member_type_field', 10, 1 );

/**
 * Set User Default
 */
function youzify_set_user_default_member_type( $user_id ) {

    if ( 'on' != youzify_member_types_option( 'youzify_enable_member_types_registration', 'on' ) ) {

        // Get Default Member Type
        $default_type = youzify_member_types_option( 'youzify_default_member_type' );

        if ( empty( $default_type ) ) {
            return false;
        }

        // Set Default Member Type
        bp_set_member_type( $user_id, $default_type );

        // Sync WordPress Roles.
        yzmt_assign_wordpress_roles( $user_id, $default_type );

    } else {

        // Get User Member Types
        $member_types = bp_get_member_type( $user_id, false );

        // Set Member Types.
        yzmt_assign_wordpress_roles( $user_id, $member_types );

    }

}

add_action( 'bp_core_activated_user', 'youzify_set_user_default_member_type' );

/**
 * Member Directory Filter.
 */
function youzify_add_md_types_tabs() {

    if ( class_exists( 'Youzify' ) ) {
        return;
    }

    // Get Member Types
    $member_types = bp_get_member_types( array( 'has_directory' => true ) );

    if ( empty( $member_types ) ) {
        return false;
    }

    foreach ( $member_types as $type_id ) {

            // Get Member Type.
            $member_type = bp_get_member_type_object( $type_id );

            // Get Type
            $type_infos = bp_get_term_by( 'slug', $type_id,'bp_member_type' );

            if ( ! isset ( $type_infos->count ) || $type_infos->count < 1 ) {
                continue;
            }

        ?>
        <li id="members-<?php echo $type_id; ?>" class="yzmt-directory-tab"><?php youzify_member_types_syling( $type_id, $member_type->db_id ); ?><a href="<?php echo bp_member_type_directory_permalink( $type_id ); ?>"><?php if ( class_exists( 'Youzify' ) ) echo '<i class="' . get_term_meta( $member_type->db_id, 'youzify_type_icon', true ) .'"></i>'; printf( __( '%1s %2s', 'youzify-member-types' ), $member_type->labels['name'], '<span>' . apply_filters( 'youzify_member_types_count', $type_infos->count, $type_id ) . '</span>' ); ?></a></li>

        <?php
    }

}

add_action( 'bp_members_directory_member_types', 'youzify_add_md_types_tabs' );

/**
 * Members Directory - Get Member Types..
 */
function youzify_get_md_members_type_list( $loop ) {

    if ( bp_is_members_directory() && isset( $_POST['scope'] ) ) {

        // Get Types Singulars
        $member_types = bp_get_member_types( array( 'has_directory' => true ) );

        if (  ! empty( $member_types ) && in_array( $_POST['scope'], $member_types ) ) {
            $loop['member_type'] = $_POST['scope'];
        }

    }

    if ( empty( $loop['member_type'] ) && ! current_user_can( 'administrator' ) && ! bp_is_user() ) {

        // Members Directory - Restricted Roles.
        $restricted_types = youzify_member_types_option( 'youzify_member_types_md_restricted_types' );

        if ( ! empty( $restricted_types ) ) {
            $loop['member_type__not_in'] = $restricted_types;
        }

    }

    return $loop;

}

add_filter( 'bp_after_has_members_parse_args', 'youzify_get_md_members_type_list', 1 );

/**
 * Get Directory Stling
 */
function youzify_member_types_syling( $type, $type_id ) {

    // Get Data.
    $left_color = get_term_meta( $type_id, 'youzify_type_bg_left_color', true );
    $right_color = get_term_meta( $type_id, 'youzify_type_bg_right_color', true );

    // if the one of the values are empty go out.
    if ( empty( $left_color ) && empty( $right_color ) ) {
        return;
    }

    // Pattern Path
    $pattern = 'url(' . YOUZIFY_MT_URL . 'public/assets/images/dotted-bg.png)';

    // Add Lists Icons Styles Class
    $icons_style = youzify_member_types_option( 'youzify_tabs_list_icons_style', 'youzify-tabs-list-gradient' );

    ?><style type="text/css">
        <?php

        // Get Selector.
        if ( $icons_style == 'youzify-tabs-list-gradient' ) {
            echo "
                .youzify-tabs-list-gradient #members-$type a i {
                    background: $pattern,linear-gradient(to right, $left_color , $right_color ) !important;
                    background: $pattern,-webkit-linear-gradient(left, $left_color , $right_color ) !important;
                }
            ";
        } elseif ( $icons_style == 'youzify-tabs-list-colorful' ) {
            echo "
                .youzify-tabs-list-colorful #members-$type a i {
                    background: $left_color;
                }
            ";
        }

        ?>
    </style>
    <?php
}

/**
 * Replace Member Type Field Value
 */
add_filter( 'bp_get_the_profile_field_value', 'yzmt_replace_member_type_field_value', 0, 3 );

function yzmt_replace_member_type_field_value( $values, $field_type, $user_id ) {

    if ( $field_type == 'member_types' ) {
        return yzmt_get_user_member_type_singular( $values );
    }

    return $values;
}


/**
 * Get User Member Type By ID.
 */
function yzmt_get_user_member_type_singular( $default_types = null ) {

    // Collect Member Types.
    $member_types = explode( ', ', $default_types );

    foreach ( $member_types as $member_type ) {

        // Get Member Type.
        $type = bp_get_member_type_object( $member_type );

        // Change Member Type Name.
        if ( isset( $type->labels['singular_name'] ) ) {
            $default_types = str_replace( $member_type, $type->labels['singular_name'], $default_types );
        }

    }

    return apply_filters( 'youzify_member_types_get_user_member_type_singular', $default_types  );
}

/**
 * Sync Roles
 */
function yzmt_assign_wordpress_roles( $user_id, $member_types ) {

    // Do not change role of administrators.
    if ( user_can( $user_id, 'manage_options' ) ) {
        return;
    }

    // Init Vars.
    $reseted = false;

    // Get User.
    $user = new WP_User( $user_id );

    // Get Member Types.
    $member_types = is_array( $member_types ) ? $member_types : array( $member_types ) ;

    // $reset_roles = false;
    foreach ( $member_types as $member_type ) {

        $type = bp_get_member_type_object( $member_type );

        if ( $type ) {

            // Get Member Type Roles.
            $type_roles = get_term_meta( $type->db_id, 'youzify_type_associated_roles', true );

            if ( ! empty( $type_roles ) ) {

                if ( ! $reseted ) {
                    $user->set_role( '' );
                    $reseted = true;
                }

                foreach ( $type_roles as $role ) {
                    // Add Roles.
                    $user->add_role( $role );
                }

            }
        }

    }

}

/**
 * Get Xprofile fields by field type.
 */
function youzify_member_types_get_xprofile_member_types_field() {

    $id = wp_cache_get( 'member_types_field_id', 'bp_xprofile' );

    if ( false === $id ) {

        global $wpdb;

        // Get Fields Table Name.
        $bp = buddypress();

        // Get Fields ID'S.
        $id = $wpdb->get_var( $wpdb->prepare( "SELECT id FROM {$bp->profile->table_name_fields} WHERE type = %s", 'member_types' ) );

        wp_cache_set( 'member_types_field_id', $id, 'bp_xprofile' );
    }

    return absint( $id );
}