<?php
// add_filter( 'bp_member_type_enable_disable', '__return_false', 9999 );

add_filter( 'manage_users_columns', 'yz_bp_delete_users_table_type_column', 9999 );
function yz_bp_delete_users_table_type_column( $columns ) {
	$columns[ bp_get_member_type_tax_name() ] = __( 'Member Types', 'youzify-member-types' );
	return $columns;
}

add_filter( 'manage_users_custom_column', 'yz_bp_users_table_populate_type_cell' , 999, 3 );

function yz_bp_users_table_populate_type_cell( $retval = '', $column_name = '', $user_id = 0 ) {
		// Only looking for member type column.
		if ( bp_get_member_type_tax_name() !== $column_name ) {
			return $retval;
		}

		// Get the member type.
		$member_type = bp_get_member_type( $user_id, false );

		// Build the Output.
		if ( $member_type ) {
			$member_types = array_filter( array_map( 'bp_get_member_type_object', $member_type ) );
			if ( ! $member_types ) {
				return $retval;
			}

			$type_links = array();
			foreach ( $member_types as $type ) {
				$url          = add_query_arg( array( 'bp-member-type' => urlencode( $type->name ) ) );
				$type_links[] = sprintf(
					'<a href="%1$s">%2$s</a>',
					esc_url( $url ),
					esc_html( $type->labels['singular_name'] )
				);
			}

			$retval = implode( ', ', $type_links );
		}

		return $retval;
	}
/**
 * Create Users submenu to manage BuddyPress types.
 *
 * @since 7.0.0
 */
function bp_members_type_admin_menu() {
	if ( ! bp_is_root_blog() ) {
		return;
	}

	if ( bp_is_network_activated() && ! bp_is_multiblog_mode() && is_network_admin() ) {
		// Adds a users.php submenu to go to the root blog Member types screen.
		$member_type_admin_url = add_query_arg( 'taxonomy', bp_get_member_type_tax_name(), get_admin_url( bp_get_root_blog_id(), 'edit-tags.php' ) );

		add_submenu_page(
			'users.php',
			__( 'Member Types', 'buddypress' ),
			__( 'Member Types', 'buddypress' ),
			'bp_moderate',
			esc_url( $member_type_admin_url )
		);

	} elseif ( ! is_network_admin() ) {
		add_submenu_page(
			'users.php',
			__( 'Member Types', 'buddypress' ),
			__( 'Member Types', 'buddypress' ),
			'bp_moderate',
			basename( add_query_arg( 'taxonomy', bp_get_member_type_tax_name(), bp_get_admin_url( 'edit-tags.php' ) ) )
		);
	}
}
add_action( 'bp_admin_menu', 'bp_members_type_admin_menu' );

/**
 * Fire the 'bp_register_type_metadata' action, where plugins should register metadata for their custom BuddyPress types.
 *
 * @since 7.0.0
 */
function bp_register_type_metadata() {

	/**
	 * Fires inside the 'bp_register_type_metadata' function, where plugins should register metadata for their custom BuddyPress types.
	 *
	 * @since 7.0.0
	 */
	do_action( 'bp_register_type_metadata' );

}

// add_action( 'bp_init', 'bp_register_taxonomies', 2 );
// add_action( 'bp_register_taxonomies', 'bp_register_member_types' );
add_action( 'bp_register_taxonomies', 'bp_register_type_metadata', 20 );


add_action( 'bp_register_type_metadata', 'bp_register_member_type_metadata' );


function bp_register_member_type_metadata() {
	$type_taxonomy = bp_get_member_type_tax_name();

	foreach ( bp_get_type_metadata_schema( false, $type_taxonomy ) as $meta_key => $meta_args ) {
		bp_register_type_meta( $type_taxonomy, $meta_key, $meta_args );
	}
}
/**
 * Registers a meta key for BuddyPress types.
 *
 * @since 7.0.0
 *
 * @param string $type_tax The BuddyPress type taxonomy.
 * @param string $meta_key The meta key to register.
 * @param array  $args     Data used to describe the meta key when registered. See
 *                         {@see register_meta()} for a list of supported arguments.
 * @return bool True if the meta key was successfully registered, false if not.
 */
function bp_register_type_meta( $type_tax, $meta_key, array $args ) {
	$taxonomies = wp_list_pluck( bp_get_default_taxonomies(), 'component' );

	if ( ! isset( $taxonomies[ $type_tax ] ) ) {
		return false;
	}

	// register_term_meta() was introduced in WP 4.9.8.
	if ( ! bp_is_running_wp( '4.9.8' ) ) {
		$args['object_subtype'] = $type_tax;

		return register_meta( 'term', $meta_key, $args );
	}

	return register_term_meta( $type_tax, $meta_key, $args );
}

function bp_is_running_wp( $version, $compare = '>=' ) {
	return version_compare( $GLOBALS['wp_version'], $version, $compare );
}

/**
 * Returns the default BuddyPress type metadata schema.
 *
 * @since 7.0.0
 *
 * @param  boolean $suppress_filters Whether to suppress filters. Default `false`.
 * @param  string  $type_taxonomy    Optional. the Type's taxonomy name.
 * @return array                     The default BuddyPress type metadata schema.
 */
function bp_get_type_metadata_schema( $suppress_filters = false, $type_taxonomy = '' ) {
	$schema = array(
		'bp_type_singular_name' => array(
			'description'       => __( 'The name of this type in singular form. ', 'buddypress' ),
			'type'              => 'string',
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		),
		'bp_type_name' => array(
			'description'       => __( 'The name of this type in plural form.', 'buddypress' ),
			'type'              => 'string',
			'single'            => true,
			'sanitize_callback' => 'sanitize_text_field',
		),
		'bp_type_has_directory' => array(
			'description'       => __( 'Make a list matching this type available on the directory.', 'buddypress' ),
			'type'              => 'boolean',
			'single'            => true,
			'sanitize_callback' => 'absint',
		),
		'bp_type_directory_slug' => array(
			'label'             => __( 'Type slug', 'buddypress' ),
			'description'       => __( 'Enter if you want the type slug to be different from its ID.', 'buddypress' ),
			'type'              => 'string',
			'single'            => true,
			'sanitize_callback' => 'sanitize_title',
		),
	);

	if ( true === $suppress_filters ) {
		return $schema;
	}

	/**
	 * Filter here to add new meta to the BuddyPress type metadata.
	 *
	 * @since 7.0.0
	 *
	 * @param array  $schema        Associative array (name => arguments).
	 * @param string $type_taxonomy The Type's taxonomy name.
	 */
	return apply_filters( 'bp_get_type_metadata_schema', $schema, $type_taxonomy );
}

/**
 * Returns arguments used by the Member type taxonomy.
 *
 * @since 7.0.0
 *
 * @return array
 */
function bp_get_member_type_tax_args() {

	/**
	 * Filters Member type taxonomy args.
	 *
	 * @since 7.0.0
	 *
	 * @param array $value Associative array (key => arg).
	 */
	return apply_filters(
		'bp_get_member_type_tax_args',
		array_merge(
			array(
				'description' => _x( 'BuddyPress Member Types', 'Member type taxonomy description', 'buddypress' ),
				'labels'      => array_merge( bp_get_member_type_tax_labels(), bp_get_taxonomy_common_labels() ),
			),
			bp_get_taxonomy_common_args()
		)
	);
}

/**
 * Returns the BP Taxonomy common arguments.
 *
 * @since 7.0.0
 *
 * @return array The BP Taxonomy common arguments.
 */
function bp_get_taxonomy_common_args() {
	return array(
		'public'        => false,
		'show_in_rest'  => false,
		'query_var'     => false,
		'rewrite'       => false,
		'show_in_menu'  => false,
		'show_tagcloud' => false,
		'show_ui'       => bp_is_root_blog() && bp_current_user_can( 'bp_moderate' ),
	);
}

/**
 * Returns the BP Taxonomy common labels.
 *
 * @since 7.0.0
 *
 * @return array The BP Taxonomy common labels.
 */
function bp_get_taxonomy_common_labels() {
	return array(
		'bp_type_name'           => _x( 'Plural Name', 'BP Type name label', 'buddypress' ),
		'bp_type_singular_name'  => _x( 'Singular name', 'BP Type singular name label', 'buddypress' ),
		'bp_type_has_directory'  => _x( 'Has Directory View', 'BP Type has directory checkbox label', 'buddypress' ),
		'bp_type_directory_slug' => _x( 'Custom type directory slug', 'BP Type slug label', 'buddypress' ),
	);
}
/**
 * Returns labels used by the member type taxonomy.
 *
 * @since 7.0.0
 *
 * @return array
 */
function bp_get_member_type_tax_labels() {

	/**
	 * Filters Member type taxonomy labels.
	 *
	 * @since 7.0.0
	 *
	 * @param array $value Associative array (name => label).
	 */
	return apply_filters(
		'bp_get_member_type_tax_labels',
		array(

			// General labels
			'name'                       => _x( 'Member Types', 'Member type taxonomy name', 'buddypress' ),
			'singular_name'              => _x( 'Member Type', 'Member type taxonomy singular name', 'buddypress' ),
			'search_items'               => _x( 'Search Member Types', 'Member type taxonomy search items label', 'buddypress' ),
			'popular_items'              => _x( 'Popular Member Types', 'Member type taxonomy popular items label', 'buddypress' ),
			'all_items'                  => _x( 'All Member Types', 'Member type taxonomy all items label', 'buddypress' ),
			'parent_item'                => _x( 'Parent Member Type', 'Member type taxonomy parent item label', 'buddypress' ),
			'parent_item_colon'          => _x( 'Parent Member Type:', 'Member type taxonomy parent item label', 'buddypress' ),
			'edit_item'                  => _x( 'Edit Member Type', 'Member type taxonomy edit item label', 'buddypress' ),
			'view_item'                  => _x( 'View Member Type', 'Member type taxonomy view item label', 'buddypress' ),
			'update_item'                => _x( 'Update Member Type', 'Member type taxonomy update item label', 'buddypress' ),
			'add_new_item'               => _x( 'Add New Member Type', 'Member type taxonomy add new item label', 'buddypress' ),
			'new_item_name'              => _x( 'New Member Type Name', 'Member type taxonomy new item name label', 'buddypress' ),
			'separate_items_with_commas' => _x( 'Separate member types with commas', 'Member type taxonomy separate items with commas label', 'buddypress' ),
			'add_or_remove_items'        => _x( 'Add or remove member types', 'Member type taxonomy add or remove items label', 'buddypress' ),
			'choose_from_most_used'      => _x( 'Choose from the most used meber types', 'Member type taxonomy choose from most used label', 'buddypress' ),
			'not_found'                  => _x( 'No member types found.', 'Member type taxonomy not found label', 'buddypress' ),
			'no_terms'                   => _x( 'No member types', 'Member type taxonomy no terms label', 'buddypress' ),
			'items_list_navigation'      => _x( 'Member Types list navigation', 'Member type taxonomy items list navigation label', 'buddypress' ),
			'items_list'                 => _x( 'Member Types list', 'Member type taxonomy items list label', 'buddypress' ),

			/* translators: Tab heading when selecting from the most used terms. */
			'most_used'                  => _x( 'Most Used', 'Member type taxonomy most used items label', 'buddypress' ),
			'back_to_items'              => _x( '&larr; Back to Member Types', 'Member type taxonomy back to items label', 'buddypress' ),

			// Specific to BuddyPress.
			'bp_type_id_label'           => _x( 'Member Type ID', 'BP Member type ID label', 'buddypress' ),
			'bp_type_id_description'     => _x( 'Enter a lower-case string without spaces or special characters (used internally to identify the member type).', 'BP Member type ID description', 'buddypress' ),
			'bp_type_show_in_list'       => _x( 'Show on Member', 'BP Member type show in list', 'buddypress' ),
		)
	);
}
/**
 * Extend generic Type metadata schema to match Member Type needs.
 *
 * @since 7.0.0
 *
 * @param array  $schema   The generic Type metadata schema.
 * @param string $taxonomy The taxonomy name the schema applies to.
 * @return array           The Member Type metadata schema.
 */
function bp_get_member_type_metadata_schema( $schema = array(), $taxonomy = '' ) {
	if ( bp_get_member_type_tax_name() === $taxonomy ) {

		// Directory.
		if ( isset( $schema['bp_type_has_directory']['description'] ) ) {
			$schema['bp_type_has_directory']['description'] = __( 'Make a list of members matching this type available on the members directory.', 'buddypress' );
		}

		// Slug.
		if ( isset( $schema['bp_type_directory_slug']['description'] ) ) {
			$schema['bp_type_directory_slug']['description'] = __( 'Enter if you want the type slug to be different from its ID.', 'buddypress' );
		}

		// List.
		$schema['bp_type_show_in_list'] = array(
			'description'       => __( 'Show where member types may be listed, like in the member header.', 'buddypress' ),
			'type'              => 'boolean',
			'single'            => true,
			'sanitize_callback' => 'absint',
		);
	}

	return $schema;
}
add_filter( 'bp_get_type_metadata_schema', 'bp_get_member_type_metadata_schema', 1, 2 );



// BuddyPress Types administration.
add_action( 'load-edit-tags.php', array( 'BP_Admin_Types', 'register_types_admin' ) );


// Load the BP Members admin.
add_action( 'bp_init', array( 'BP_Members_Admin', 'register_members_admin' ) );

/**
 * Checks whether a member type already exists.
 *
 * @since 7.0.0
 *
 * @param  boolean $exists  True if the member type already exists. False otherwise.
 * @param  string  $type_id The member type identifier.
 * @return boolean          True if the member type already exists. False otherwise.
 */
function bp_members_type_admin_type_exists( $exists = false, $type_id = '' ) {
	if ( ! $type_id ) {
		return $exists;
	}

	return ! is_null( bp_get_member_type_object( $type_id ) );
}
add_filter( bp_get_member_type_tax_name() . '_check_existing_type', 'bp_members_type_admin_type_exists', 1, 2 );

/**
 * Set the feedback messages for the Member Types Admin actions.
 *
 * @since 7.0.0
 *
 * @param array  $messages The feedback messages.
 * @return array           The feedback messages including the ones for the Member Types Admin actions.
 */
function bp_members_type_admin_updated_messages( $messages = array() ) {
	$type_taxonomy = bp_get_member_type_tax_name();

	$messages[ $type_taxonomy ] = array(
		0  => '',
		1  => __( 'Please define the Member Type ID field.', 'buddypress' ),
		2  => __( 'Member type successfully added.', 'buddypress' ),
		3  => __( 'Sorry, there was an error and the Member type wasn’t added.', 'buddypress' ),
		// The following one needs to be != 5.
		4  => __( 'Member type successfully updated.', 'buddypress' ),
		5  => __( 'Sorry, this Member type already exists.', 'buddypress' ),
		6  => __( 'Sorry, the Member type was not deleted: it does not exist.', 'buddypress' ),
		7  => __( 'Sorry, This Member type is registered using code, deactivate the plugin or remove the custom code before trying to delete it again.', 'buddypress' ),
		8  => __( 'Sorry, there was an error while trying to delete this Member type.', 'buddypress' ),
		9  => __( 'Member type successfully deleted.', 'buddypress' ),
		10 => __( 'Member type could not be updated due to missing required information.', 'buddypress' ),
	);

	return $messages;
}
add_filter( 'term_updated_messages', 'bp_members_type_admin_updated_messages' );

/**
 * Clear the Database object types cache.
 *
 * @since 7.0.0
 *
 * @param int $type_id The Type's term ID.
 * @param string $taxonomy The Type's taxonomy name.
 */
function bp_clear_object_type_terms_cache( $type_id = 0, $taxonomy = '' ) {
	wp_cache_delete( $taxonomy, 'bp_object_terms' );
}
add_action( 'bp_type_inserted', 'bp_clear_object_type_terms_cache' );
add_action( 'bp_type_updated', 'bp_clear_object_type_terms_cache' );
add_action( 'bp_type_deleted', 'bp_clear_object_type_terms_cache' );

/***/

function youzify_bp_add_database_member_types( $types, $args, $operator ) {

	// Merge with types available into the database.
	if ( ! isset( $args['code'] ) || true !== $args['code'] ) {
		$types = bp_get_taxonomy_types( bp_get_member_type_tax_name(), $types );
	}

	$types = wp_filter_object_list( $types, $args, $operator );

	return $types;

}

add_filter( 'bp_get_member_types', 'youzify_bp_add_database_member_types', 10, 3 );

function yz_bp_add_member_type_list( $meta ) {
	$meta_types = bp_get_member_type_list( bp_displayed_user_id(),
				array(
					'label'        => array(
						'plural'   => __( 'Member Types:', 'buddypress' ),
						'singular' => __( 'Member Type:', 'buddypress' ),
					),
					'list_element' => 'span',
				) );

	if ( ! empty( $meta_types ) ) {
		$meta['yz_types'] = $meta_types;
	}

	return $meta;
}

add_filter( 'bp_nouveau_get_member_meta', 'yz_bp_add_member_type_list' );

function bp_get_member_type_list( $user_id = 0, $r = array() ) {
	if ( empty( $user_id ) ) {
		$user_id = bp_displayed_user_id();
	}

	$r = bp_parse_args(
		$r,
		array(
			'parent_element'    => 'div',
			'parent_attr'       => array(
				'class' => 'bp-member-type-list',
			),
			'label'             => array(),
			'label_element'     => 'strong',
			'label_attr'        => array(),
			'show_all'          => false,
			'list_element'      => '',
			'list_element_attr' => array(),
		),
		'member_type_list'
	);

	// Should the label be output?
	$has_label = ! empty( $r['label'] );

	$labels = wp_parse_args(
		$r['label'],
		array(
			'plural'   => __( 'Member Types:', 'buddypress' ),
			'singular' => __( 'Member Type:', 'buddypress' ),
		)
	);

	$retval = '';
	$types  = bp_get_member_type( $user_id, false );

	if ( $types ) {
		// Make sure we can show the type in the list.
		if ( false === $r['show_all'] ) {
			$types = array_intersect( bp_get_member_types( array( 'show_in_list' => true ) ), $types );
			if ( empty( $types ) ) {
				return $retval;
			}
		}

		$before = $after = $label = '';
		$count  = count( $types );

		if ( 1 === $count ) {
			$label_text = $labels['singular'];
		} else {
			$label_text = $labels['plural'];
		}

		// Render parent element.
		if ( ! empty( $r['parent_element'] ) ) {
			$parent_elem = new BP_Core_HTML_Element( array(
				'element' => $r['parent_element'],
				'attr'    => $r['parent_attr'],
			) );

			// Set before and after.
			$before = $parent_elem->get( 'open_tag' );
			$after  = $parent_elem->get( 'close_tag' );
		}

		// Render label element.
		if ( ! empty( $r['label_element'] ) ) {
			$label = new BP_Core_HTML_Element( array(
				'element'    => $r['label_element'],
				'attr'       => $r['label_attr'],
				'inner_html' => esc_html( $label_text ),
			) );
			$label = $label->contents() . ' ';

		// No element, just the label.
		} elseif ( $has_label ) {
			$label = esc_html( $label_text );
		}

		// The list of types.
		$list = implode( ', ', array_map( 'yz_bp_get_member_type_directory_link', $types ) );

		// Render the list of types element.
		if ( ! empty( $r['list_element'] ) ) {
			$list_element = new BP_Core_HTML_Element( array(
				'element'    => $r['list_element'],
				'attr'       => $r['list_element_attr'],
				'inner_html' => $list,
			) );

			$list = $list_element->contents();
		}

		// Comma-delimit each type into the group type directory link.
		$label .= $list;

		// Retval time!
		$retval = $before . $label . $after;
	}

	return $retval;
}
	function yz_bp_get_member_type_directory_link( $member_type = '' ) {
		if ( empty( $member_type ) ) {
			return '';
		}

		$member_type_object = bp_get_member_type_object( $member_type );

		if ( ! isset( $member_type_object->labels['name'] ) ) {
			return '';
		}

		$member_type_text = $member_type_object->labels['name'];
		if ( isset( $member_type_object->labels['singular_name'] ) && $member_type_object->labels['singular_name'] ) {
			$member_type_text = $member_type_object->labels['singular_name'];
		}

		if ( empty( $member_type_object->has_directory ) ) {
			return esc_html( $member_type_text );
		}

		return sprintf(
			'<a href="%1$s">%2$s</a>',
			esc_url( bp_get_member_type_directory_permalink( $member_type ) ),
			esc_html( $member_type_text )
		);
	}
