<?php
/* @var $this NewsletterSubscriptionAdmin */
/* @var $controls NewsletterSubscriptionAdmin */

defined('ABSPATH') || exit;

if (!$controls->is_action()) {
    $controls->data = $this->get_options('htmlforms');
}

if ($controls->is_action('save')) {
    $this->save_options($controls->data, 'htmlforms');
    $controls->add_message_saved();
}
?>

<div class="wrap" id="tnp-wrap">

    <?php include NEWSLETTER_DIR . '/header.php'; ?>

    <div id="tnp-heading">

        <h2><?php _e('HTML Forms', 'newsletter') ?></h2>
        <p>
            Here you can store your hand coded forms to recall them from short codes.
            <a href="https://www.thenewsletterplugin.com/plugins/newsletter/newsletter-forms" target="_blank">Read more about forms</a>.
        </p>

    </div>

    <div id="tnp-body">
        
        <?php $controls->show(); ?>

        <form method="post" action="">
            <?php $controls->init(); ?>

            <div id="tabs">

                <ul>
                    <li><a href="#tabs-forms">Forms</a></li>
                    <li><a href="#tabs-html">HTML sample</a></li>
                </ul>

                <div id="tabs-forms">
                    <table class="form-table">
                        <?php for ($i = 1; $i <= 10; $i++) { ?>
                            <tr>
                                <th>Form <?php echo $i; ?></th>
                                <td>
                                    <?php $controls->textarea('form_' . $i); ?>
                                    <br />
                                    <?php $controls->button_save(); ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </table>
                </div>
                
                <div id="tabs-html">

                    <p>This panel shows the form HTML code generated by Newsletter if you want to copy it as starting point for a custom form.</p>

                    <h3>Standard form code</h3>
                    <textarea readonly style="width: 100%; height: 500px; font-family: monospace"><?php echo esc_html(NewsletterSubscription::instance()->get_subscription_form()); ?></textarea>

                    <h3>Widget form code</h3>
                    <textarea readonly style="width: 100%; height: 500px; font-family: monospace"><?php echo htmlspecialchars(NewsletterSubscription::instance()->get_subscription_form()); ?></textarea>

                </div>

            </div>
        </form>

    </div>

    <?php include NEWSLETTER_DIR . '/tnp-footer.php'; ?>

</div> 
